<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Agent Dashboard | <?php echo $this->customlib->getAppName(); ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/chartjs/Chart.min.css">

    <style>
        .agent-header {
            background: linear-gradient(135deg, #16a085 0%, #27ae60 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 25px;
        }
        
        .stat-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            text-align: center;
        }
        
        .stat-number {
            font-size: 2.5em;
            font-weight: bold;
            margin-bottom: 5px;
        }
        
        .stat-label {
            color: #666;
            font-size: 14px;
        }
        
        .contract-card {
            background: white;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .progress-ring {
            position: relative;
            display: inline-block;
            margin: 10px;
        }
        
        .progress-percentage {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-weight: bold;
            font-size: 14px;
        }
        
        .patient-row {
            border-bottom: 1px solid #eee;
            padding: 8px 0;
        }
        
        .patient-row:last-child {
            border-bottom: none;
        }
        
        .alert-commission {
            background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
            color: white;
            border: none;
        }
        
        .chart-container {
            background: white;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <div class="content-wrapper">
            <!-- Content Header -->
            <section class="content-header">
                <h1><i class="fa fa-dashboard"></i> Agent Performance Dashboard</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo base_url(); ?>admin/agent/configure">Agent Config</a></li>
                    <li class="active"><?php echo $agent['agent_name']; ?></li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        
                        <!-- Agent Header -->
                        <div class="agent-header">
                            <div class="row">
                                <div class="col-md-8">
                                    <h2><i class="fa fa-user-md"></i> <?php echo $agent['agent_name']; ?></h2>
                                    <p style="margin: 5px 0;"><strong>Company:</strong> <?php echo $agent['company_name'] ?: 'N/A'; ?></p>
                                    <p style="margin: 5px 0;"><strong>Contact:</strong> <?php echo $agent['contact_person']; ?> | <?php echo $agent['phone']; ?></p>
                                    <p style="margin-bottom: 0;"><strong>Agent Code:</strong> <?php echo $agent['agent_code']; ?></p>
                                </div>
                                <div class="col-md-4 text-right">
                                    <button class="btn btn-light btn-lg" onclick="window.print()">
                                        <i class="fa fa-print"></i> Print Report
                                    </button>
                                    <br><br>
                                    <span class="badge" style="background: rgba(255,255,255,0.3); padding: 8px 15px; font-size: 14px;">
                                        Status: <?php echo ucfirst($agent['status']); ?>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <!-- Statistics Cards -->
                        <div class="row">
                            <div class="col-md-2">
                                <div class="stat-card">
                                    <div class="stat-number text-primary"><?php echo $stats['total_contracts']; ?></div>
                                    <div class="stat-label">Total Contracts</div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="stat-card">
                                    <div class="stat-number text-success"><?php echo $stats['active_contracts']; ?></div>
                                    <div class="stat-label">Active Contracts</div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="stat-card">
                                    <div class="stat-number text-info"><?php echo $stats['total_patients']; ?></div>
                                    <div class="stat-label">Patients Registered</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <div class="stat-number text-warning">KES <?php echo number_format($stats['total_commission'], 2); ?></div>
                                    <div class="stat-label">Commission Earned (This Year)</div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stat-card">
                                    <div class="stat-number text-danger"><?php echo $stats['contracts_expiring']; ?></div>
                                    <div class="stat-label">Expiring Soon</div>
                                </div>
                            </div>
                        </div>

                        <!-- Contracts Overview -->
                        <div class="row">
                            <div class="col-md-8">
                                <div class="box box-primary">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"><i class="fa fa-file-text"></i> Active Contracts</h3>
                                    </div>
                                    <div class="box-body">
                                        <?php if (!empty($agent['contracts'])): ?>
                                            <?php foreach ($agent['contracts'] as $contract): ?>
                                                <?php 
                                                    $utilization = $contract['patient_limit'] > 0 ? 
                                                        round(($contract['patients_registered'] / $contract['patient_limit']) * 100, 1) : 0;
                                                    $remaining = $contract['patient_limit'] - $contract['patients_registered'];
                                                    $days_to_expiry = (strtotime($contract['contract_end_date']) - time()) / (60 * 60 * 24);
                                                ?>
                                                <div class="contract-card">
                                                    <div class="row">
                                                        <div class="col-md-3">
                                                            <h4 style="margin-top: 0;">
                                                                <img src="<?php echo base_url(); ?>assets/images/flags/<?php echo strtolower($contract['country_code']); ?>.png" 
                                                                     style="width: 24px; height: 16px; margin-right: 8px;" 
                                                                     onerror="this.style.display='none'">
                                                                <?php echo $contract['country_name']; ?>
                                                            </h4>
                                                            <p style="color: #666; margin: 0;"><?php echo $contract['contract_name']; ?></p>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <strong>Package Cost:</strong><br>
                                                            <?php echo $contract['currency_code']; ?> <?php echo number_format($contract['total_cost_per_patient'], 2); ?>
                                                            <br><small>Commission: <?php echo $contract['currency_code']; ?> <?php echo number_format($contract['agent_commission_per_patient'], 2); ?></small>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="progress" style="height: 20px;">
                                                                <div class="progress-bar <?php echo $utilization > 80 ? 'progress-bar-danger' : ($utilization > 60 ? 'progress-bar-warning' : 'progress-bar-success'); ?>" 
                                                                     style="width: <?php echo $utilization; ?>%">
                                                                    <?php echo $utilization; ?>%
                                                                </div>
                                                            </div>
                                                            <small><?php echo $contract['patients_registered']; ?>/<?php echo $contract['patient_limit']; ?> patients | <?php echo $remaining; ?> remaining</small>
                                                        </div>
                                                        <div class="col-md-2 text-right">
                                                            <small>Expires in<br><strong><?php echo floor($days_to_expiry); ?> days</strong></small>
                                                            <?php if ($days_to_expiry <= 30): ?>
                                                                <br><span class="label label-warning">Expiring Soon</span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                No active contracts. Create contracts to start registering patients.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <!-- Commission Summary -->
                                <div class="box box-warning">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"><i class="fa fa-money"></i> Commission Overview</h3>
                                    </div>
                                    <div class="box-body">
                                        <div class="alert alert-commission">
                                            <h3 style="margin-top: 0;">KES <?php echo number_format($stats['total_commission'], 2); ?></h3>
                                            <p style="margin-bottom: 0;">Total commission earned this year from <?php echo $stats['total_patients']; ?> patients</p>
                                        </div>
                                        
                                        <?php if (!empty($agent['contracts'])): ?>
                                            <h5>Commission per Country:</h5>
                                            <?php foreach ($agent['contracts'] as $contract): ?>
                                                <?php 
                                                    $country_commission = $contract['patients_registered'] * $contract['agent_commission_per_patient'];
                                                ?>
                                                <div style="margin-bottom: 10px;">
                                                    <div style="display: flex; justify-content: space-between;">
                                                        <span><?php echo $contract['country_name']; ?>:</span>
                                                        <strong><?php echo $contract['currency_code']; ?> <?php echo number_format($country_commission, 2); ?></strong>
                                                    </div>
                                                    <small class="text-muted"><?php echo $contract['patients_registered']; ?> patients × <?php echo $contract['currency_code']; ?><?php echo number_format($contract['agent_commission_per_patient'], 2); ?></small>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <!-- Alerts -->
                                <?php if ($stats['contracts_near_limit'] > 0 || $stats['contracts_expiring'] > 0): ?>
                                    <div class="box box-danger">
                                        <div class="box-header with-border">
                                            <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Alerts</h3>
                                        </div>
                                        <div class="box-body">
                                            <?php if ($stats['contracts_near_limit'] > 0): ?>
                                                <div class="alert alert-warning">
                                                    <strong><?php echo $stats['contracts_near_limit']; ?></strong> contract(s) near patient limit (>80% full)
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if ($stats['contracts_expiring'] > 0): ?>
                                                <div class="alert alert-danger">
                                                    <strong><?php echo $stats['contracts_expiring']; ?></strong> contract(s) expiring within 30 days
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Recent Patient Registrations -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-info">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"><i class="fa fa-users"></i> Recent Patient Registrations</h3>
                                        <div class="box-tools pull-right">
                                            <span class="badge bg-blue"><?php echo count($recent_patients); ?></span>
                                        </div>
                                    </div>
                                    <div class="box-body">
                                        <?php if (!empty($recent_patients)): ?>
                                            <div class="table-responsive">
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>Registration #</th>
                                                            <th>Patient Name</th>
                                                            <th>Destination</th>
                                                            <th>Registration Date</th>
                                                            <th>Status</th>
                                                            <th>Commission</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php foreach ($recent_patients as $patient): ?>
                                                            <tr>
                                                                <td><code><?php echo $patient['registration_number']; ?></code></td>
                                                                <td><?php echo $patient['patient_name']; ?></td>
                                                                <td><?php echo $patient['country_name']; ?></td>
                                                                <td><?php echo date('M j, Y', strtotime($patient['registration_date'])); ?></td>
                                                                <td>
                                                                    <span class="label label-<?php echo $patient['status'] === 'registered' ? 'primary' : ($patient['status'] === 'approved' ? 'success' : 'default'); ?>">
                                                                        <?php echo ucfirst($patient['status']); ?>
                                                                    </span>
                                                                </td>
                                                                <td>KES <?php echo number_format($patient['agent_commission'], 2); ?></td>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        <?php else: ?>
                                            <div class="alert alert-info">
                                                No patient registrations found for this agent.
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <!-- Scripts -->
    <script src="<?php echo base_url(); ?>backend/plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/dist/js/app.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/plugins/chartjs/Chart.min.js"></script>

    <script>
    $(document).ready(function() {
        // Auto-refresh data every 5 minutes
        setInterval(function() {
            location.reload();
        }, 300000);
        
        // Add tooltips to progress bars
        $('.progress').each(function() {
            $(this).attr('title', 'Click to view detailed breakdown');
            $(this).tooltip();
        });
    });
    </script>
</body>
</html>