<?php
class Workflow_model extends CI_Model {
    
    public function getPatientTypes() {
        return $this->db->get('patient_types')->result_array();
    }
    
    public function getPatientType($code) {
        return $this->db->where('type_code', $code)->get('patient_types')->row_array();
    }
    
    public function initializePatientJourney($patient_id, $patient_type_id) {
        // Get workflow steps for this patient type
        $patient_type = $this->db->where('id', $patient_type_id)->get('patient_types')->row();
        $steps = explode(',', $patient_type->workflow_steps);
        
        // Create initial journey record
        $journey_data = [
            'patient_id' => $patient_id,
            'patient_type_id' => $patient_type_id,
            'current_step' => $steps[0],
            'step_order' => 1,
            'status' => 'pending'
        ];
        
        $this->db->insert('patient_journey', $journey_data);
        
        // Update patient workflow status
        $this->db->where('id', $patient_id)->update('patients', [
            'workflow_status' => 'in_progress',
            'patient_type_id' => $patient_type_id
        ]);
        
        return $this->db->insert_id();
    }
    
    public function getPatientJourney($patient_id) {
        $this->db->select('pj.*, pt.type_name, pt.workflow_steps');
        $this->db->from('patient_journey pj');
        $this->db->join('patient_types pt', 'pt.id = pj.patient_type_id');
        $this->db->where('pj.patient_id', $patient_id);
        $this->db->where('pj.status !=', 'completed');
        $this->db->order_by('pj.step_order', 'ASC');
        
        return $this->db->get()->result_array();
    }
    
    public function completeCurrentStep($journey_id, $notes = '') {
        // Get current journey step
        $journey = $this->db->where('id', $journey_id)->get('patient_journey')->row();
        
        if (!$journey) {
            return ['status' => 'error', 'message' => 'Journey not found'];
        }
        
        // Mark current step as completed
        $this->db->where('id', $journey_id)->update('patient_journey', [
            'status' => 'completed',
            'completed_at' => date('Y-m-d H:i:s'),
            'notes' => $notes
        ]);
        
        // Get next step
        $patient_type = $this->db->where('id', $journey->patient_type_id)->get('patient_types')->row();
        $steps = explode(',', $patient_type->workflow_steps);
        $next_step_index = $journey->step_order;
        
        if ($next_step_index < count($steps)) {
            // Create next step
            $next_journey_data = [
                'patient_id' => $journey->patient_id,
                'patient_type_id' => $journey->patient_type_id,
                'current_step' => $steps[$next_step_index],
                'step_order' => $next_step_index + 1,
                'status' => 'pending'
            ];
            
            $this->db->insert('patient_journey', $next_journey_data);
            
            return [
                'status' => 'success', 
                'message' => 'Step completed, moved to: ' . $steps[$next_step_index],
                'next_step' => $steps[$next_step_index]
            ];
        } else {
            // Workflow completed
            $this->db->where('id', $journey->patient_id)->update('patients', [
                'workflow_status' => 'completed'
            ]);
            
            return [
                'status' => 'success', 
                'message' => 'Workflow completed successfully',
                'workflow_completed' => true
            ];
        }
    }
}