<?php

class Lab_model extends MY_model {

    public function valid_lab_name($str) {
        $name = $this->input->post('name');
        $id   = $this->input->post('id');
        if (!isset($id)) {
            $id = 0;
        }
        if ($this->check_lab_exists($name, $id)) {
            $this->form_validation->set_message('check_exists', 'Record already exists');
            return false;
        } else {
            return true;
        }
    }

    public function check_lab_exists($name, $id) {
        $this->db->where('name', $name);
        $this->db->where('id !=', $id);
        $query = $this->db->get('lab_tests');
        if ($query->num_rows() > 0) {
            return true;
        } else {
            return false;
        }
    }

    public function getLabTests($id = null) {
        if ($id != null) {
            $this->db->where('id', $id);
        }
        $query = $this->db->get('lab_tests');
        return $query->result_array();
    }

    public function addLabTest($data) {
        $this->db->insert('lab_tests', $data);
        return $this->db->insert_id();
    }

    public function updateLabTest($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('lab_tests', $data);
        return $this->db->affected_rows();
    }

    public function deleteLabTest($id) {
        $this->db->where('id', $id);
        $this->db->delete('lab_tests');
        return $this->db->affected_rows();
    }

    public function getLabTestCategories() {
        $query = $this->db->get('lab_test_categories');
        return $query->result_array();
    }

    public function addLabTestCategory($data) {
        $this->db->insert('lab_test_categories', $data);
        return $this->db->insert_id();
    }

    public function getLabResults($patient_id = null) {
        $this->db->select('lab_results.*, lab_tests.name as test_name, patients.patient_name, staff.name as technician_name');
        $this->db->from('lab_results');
        $this->db->join('lab_tests', 'lab_tests.id = lab_results.test_id');
        $this->db->join('patients', 'patients.id = lab_results.patient_id');
        $this->db->join('staff', 'staff.id = lab_results.technician_id');
        if ($patient_id != null) {
            $this->db->where('lab_results.patient_id', $patient_id);
        }
        $query = $this->db->get();
        return $query->result_array();
    }

    public function addLabResult($data) {
        $this->db->insert('lab_results', $data);
        return $this->db->insert_id();
    }

    public function updateLabResult($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('lab_results', $data);
        return $this->db->affected_rows();
    }

    public function getLabTechnicians() {
        $this->db->select('staff.*');
        $this->db->from('staff');
        $this->db->join('staff_roles', 'staff_roles.staff_id = staff.id');
        $this->db->where('staff_roles.role_id', 4); // Assuming 4 is lab technician role ID
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getLabTestsByCategory($category_id) {
        $this->db->where('category_id', $category_id);
        $query = $this->db->get('lab_tests');
        return $query->result_array();
    }

    public function getLabTestReferenceRanges($test_id) {
        $this->db->where('test_id', $test_id);
        $query = $this->db->get('lab_test_reference_ranges');
        return $query->result_array();
    }

    public function addLabTestReferenceRange($data) {
        $this->db->insert('lab_test_reference_ranges', $data);
        return $this->db->insert_id();
    }

    public function updateLabTestReferenceRange($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('lab_test_reference_ranges', $data);
        return $this->db->affected_rows();
    }

    public function getLabTestParameters($test_id) {
        $this->db->where('test_id', $test_id);
        $query = $this->db->get('lab_test_parameters');
        return $query->result_array();
    }

    public function addLabTestParameter($data) {
        $this->db->insert('lab_test_parameters', $data);
        return $this->db->insert_id();
    }

    public function updateLabTestParameter($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('lab_test_parameters', $data);
        return $this->db->affected_rows();
    }
    
    public function getlabName($id = null)
{
    if (!empty($id)) {
        $this->db->where("id", $id);
        $query = $this->db->get('lab');
        if ($query->num_rows() > 0) {
            $result = $query->row();
            return $result->lab_name;
        }
        return false;
    } else {
        $query = $this->db->select('id, lab_name')
                         ->order_by('lab_name', 'ASC')
                         ->get('lab');
        return $query->result_array();
    }
}
public function getradioparameter($id = null)
{
    if (!empty($id)) {
        $this->db->select('radiology_parameter.*, unit.unit_name');
        $this->db->from('radiology_parameter');
        $this->db->join('unit', 'radiology_parameter.unit = unit.id', 'left');
        $this->db->where("radiology_parameter.id", $id);
        $query = $this->db->get();
        return $query->row_array();
    } else {
        $this->db->select('radiology_parameter.*, unit.unit_name');
        $this->db->from('radiology_parameter');
        $this->db->join('unit', 'radiology_parameter.unit = unit.id', 'left');
        $this->db->order_by('radiology_parameter.id', 'desc');
        $query = $this->db->get();
        return $query->result_array();
    }
}
}
