<?php
/**
 * CodeIgniter Migration for Insurance Pricing System
 * File: application/migrations/001_create_insurance_tables.php
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_insurance_tables extends CI_Migration {

    public function up() {
        // 1. Insurance Companies Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'company_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'company_code' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'contact_person' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'address' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'website' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'logo_path' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ],
            'commission_rate' => [
                'type' => 'DECIMAL',
                'constraint' => '5,2',
                'default' => 0.00
            ],
            'payment_terms' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'suspended'],
                'default' => 'active'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'updated_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['company_name'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key(['company_code'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('status');
        $this->dbforge->create_table('insurance_companies');

        // 2. Item Families Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'family_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'family_code' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'parent_family_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive'],
                'default' => 'active'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['family_name'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('parent_family_id');
        $this->dbforge->add_key('status');
        $this->dbforge->create_table('item_families');

        // 3. Master Items Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'item_code' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'item_name' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
            ],
            'item_type' => [
                'type' => 'ENUM',
                'constraint' => ['Stock', 'Service', 'Medicine', 'Equipment', 'Procedure'],
                'default' => 'Stock'
            ],
            'item_family_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'generic_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'brand_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'manufacturer' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'unit_of_measure' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'strength' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'dosage_form' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'base_price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => 0.00
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'is_active' => [
                'type' => 'ENUM',
                'constraint' => ['yes', 'no'],
                'default' => 'yes'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'updated_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['item_code'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('item_name');
        $this->dbforge->add_key('item_type');
        $this->dbforge->add_key('item_family_id');
        $this->dbforge->add_key('is_active');
        $this->dbforge->create_table('master_items');

        // 4. Insurance Pricing Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'insurance_company_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'master_item_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'null' => TRUE
            ],
            'item_name' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
            ],
            'item_type' => [
                'type' => 'ENUM',
                'constraint' => ['Stock', 'Service', 'Medicine', 'Equipment', 'Procedure'],
                'default' => 'Stock'
            ],
            'item_family' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'item_price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => 0.00
            ],
            'markup_percentage' => [
                'type' => 'DECIMAL',
                'constraint' => '5,2',
                'null' => TRUE
            ],
            'discount_percentage' => [
                'type' => 'DECIMAL',
                'constraint' => '5,2',
                'null' => TRUE
            ],
            'effective_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'expiry_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'approval_status' => [
                'type' => 'ENUM',
                'constraint' => ['pending', 'approved', 'rejected'],
                'default' => 'pending'
            ],
            'approved_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'approved_at' => [
                'type' => 'TIMESTAMP',
                'null' => TRUE
            ],
            'rejection_reason' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'import_batch_id' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'import_source' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'expired'],
                'default' => 'active'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'updated_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('insurance_company_id');
        $this->dbforge->add_key('master_item_id');
        $this->dbforge->add_key('item_name');
        $this->dbforge->add_key('item_type');
        $this->dbforge->add_key('status');
        $this->dbforge->add_key('approval_status');
        $this->dbforge->add_key('effective_date');
        $this->dbforge->add_key('import_batch_id');
        $this->dbforge->create_table('insurance_pricing');

        // 5. Import History Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'batch_id' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],
            'file_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'file_size' => [
                'type' => 'BIGINT',
                'constraint' => 20,
                'null' => TRUE
            ],
            'file_path' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ],
            'total_records' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'processed_records' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'successful_records' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'failed_records' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'import_type' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'default' => 'insurance_pricing'
            ],
            'import_status' => [
                'type' => 'ENUM',
                'constraint' => ['pending', 'processing', 'completed', 'failed', 'cancelled'],
                'default' => 'pending'
            ],
            'error_log' => [
                'type' => 'LONGTEXT',
                'null' => TRUE
            ],
            'summary_report' => [
                'type' => 'LONGTEXT',
                'null' => TRUE
            ],
            'processing_time' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'started_at' => [
                'type' => 'TIMESTAMP',
                'null' => TRUE
            ],
            'completed_at' => [
                'type' => 'TIMESTAMP',
                'null' => TRUE
            ],
            'imported_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['batch_id'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('import_status');
        $this->dbforge->add_key('imported_by');
        $this->dbforge->add_key('created_at');
        $this->dbforge->create_table('import_history');

        // 6. Price Change Log Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'insurance_pricing_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'old_price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'null' => TRUE
            ],
            'new_price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'change_reason' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'change_type' => [
                'type' => 'ENUM',
                'constraint' => ['manual', 'import', 'system', 'bulk'],
                'default' => 'manual'
            ],
            'effective_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'changed_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('insurance_pricing_id');
        $this->dbforge->add_key('changed_by');
        $this->dbforge->add_key('created_at');
        $this->dbforge->create_table('price_change_log');

        // Add Foreign Key Constraints (if supported)
        if ($this->db->dbdriver !== 'sqlite3') {
            // Foreign keys for item_families
            $this->db->query('ALTER TABLE item_families ADD CONSTRAINT fk_item_families_parent 
                              FOREIGN KEY (parent_family_id) REFERENCES item_families(id) 
                              ON DELETE SET NULL ON UPDATE CASCADE');

            // Foreign keys for master_items
            $this->db->query('ALTER TABLE master_items ADD CONSTRAINT fk_master_items_family 
                              FOREIGN KEY (item_family_id) REFERENCES item_families(id) 
                              ON DELETE SET NULL ON UPDATE CASCADE');

            // Foreign keys for insurance_pricing
            $this->db->query('ALTER TABLE insurance_pricing ADD CONSTRAINT fk_insurance_pricing_company 
                              FOREIGN KEY (insurance_company_id) REFERENCES insurance_companies(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');

            $this->db->query('ALTER TABLE insurance_pricing ADD CONSTRAINT fk_insurance_pricing_item 
                              FOREIGN KEY (master_item_id) REFERENCES master_items(id) 
                              ON DELETE SET NULL ON UPDATE CASCADE');

            // Foreign keys for price_change_log
            $this->db->query('ALTER TABLE price_change_log ADD CONSTRAINT fk_price_change_log_pricing 
                              FOREIGN KEY (insurance_pricing_id) REFERENCES insurance_pricing(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
        }

        // Insert Default Item Families
        $default_families = [
            ['family_name' => 'MEDICATION', 'family_code' => 'MED', 'description' => 'Pharmaceutical medicines and drugs'],
            ['family_name' => 'PHARMACY OTHERS', 'family_code' => 'PH_OTH', 'description' => 'Other pharmacy items and supplies'],
            ['family_name' => 'LABORATORY', 'family_code' => 'LAB', 'description' => 'Laboratory tests and procedures'],
            ['family_name' => 'RADIOLOGY', 'family_code' => 'RAD', 'description' => 'Radiology and imaging services'],
            ['family_name' => 'CONSULTATION', 'family_code' => 'CONS', 'description' => 'Medical consultations and examinations'],
            ['family_name' => 'SURGERY', 'family_code' => 'SURG', 'description' => 'Surgical procedures and operations'],
            ['family_name' => 'EMERGENCY', 'family_code' => 'EMER', 'description' => 'Emergency services and procedures'],
            ['family_name' => 'DENTAL', 'family_code' => 'DENT', 'description' => 'Dental services and procedures'],
            ['family_name' => 'PHYSIOTHERAPY', 'family_code' => 'PHYSIO', 'description' => 'Physiotherapy and rehabilitation services'],
            ['family_name' => 'MEDICAL SUPPLIES', 'family_code' => 'MED_SUP', 'description' => 'Medical supplies and equipment']
        ];

        $this->db->insert_batch('item_families', $default_families);

        // Insert Sample Insurance Companies (based on your Excel file)
        $default_companies = [
            ['company_name' => 'AAR Insurance', 'company_code' => 'AAR'],
            ['company_name' => 'Acorn', 'company_code' => 'ACORN'],
            ['company_name' => 'Actom Kenya', 'company_code' => 'ACTOM'],
            ['company_name' => 'Acumen East Africa', 'company_code' => 'ACUMEN'],
            ['company_name' => 'Afya Imara', 'company_code' => 'AFYA'],
            ['company_name' => 'AoN Minet', 'company_code' => 'AON'],
            ['company_name' => 'APA Managed', 'company_code' => 'APA'],
            ['company_name' => 'CIC', 'company_code' => 'CIC'],
            ['company_name' => 'First Assurance', 'company_code' => 'FIRST'],
            ['company_name' => 'Heritage', 'company_code' => 'HERITAGE'],
            ['company_name' => 'Jubilee Insurance', 'company_code' => 'JUBILEE'],
            ['company_name' => 'Minet Kenya', 'company_code' => 'MINET'],
            ['company_name' => 'StarDiscover', 'company_code' => 'STAR'],
            ['company_name' => 'UAP', 'company_code' => 'UAP']
        ];

        $this->db->insert_batch('insurance_companies', $default_companies);

        // Create additional indexes for better performance
        $this->db->query('CREATE INDEX idx_insurance_pricing_composite ON insurance_pricing (insurance_company_id, item_type, status)');
        $this->db->query('CREATE INDEX idx_master_items_composite ON master_items (item_type, is_active)');
    }

    public function down() {
        // Drop foreign key constraints first (if they exist)
        if ($this->db->dbdriver !== 'sqlite3') {
            $this->db->query('ALTER TABLE item_families DROP FOREIGN KEY IF EXISTS fk_item_families_parent');
            $this->db->query('ALTER TABLE master_items DROP FOREIGN KEY IF EXISTS fk_master_items_family');
            $this->db->query('ALTER TABLE insurance_pricing DROP FOREIGN KEY IF EXISTS fk_insurance_pricing_company');
            $this->db->query('ALTER TABLE insurance_pricing DROP FOREIGN KEY IF EXISTS fk_insurance_pricing_item');
            $this->db->query('ALTER TABLE price_change_log DROP FOREIGN KEY IF EXISTS fk_price_change_log_pricing');
        }

        // Drop tables in reverse order
        $this->dbforge->drop_table('price_change_log', TRUE);
        $this->dbforge->drop_table('import_history', TRUE);
        $this->dbforge->drop_table('insurance_pricing', TRUE);
        $this->dbforge->drop_table('master_items', TRUE);
        $this->dbforge->drop_table('item_families', TRUE);
        $this->dbforge->drop_table('insurance_companies', TRUE);
    }
}

?>