<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Roles extends Admin_Controller
{

    private $perm_category = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->config('mailsms');
        $this->perm_category = $this->config->item('perm_category');
    }

    public function index()
    {
        $data['title'] = $this->lang->line('add_role');
        $this->session->set_userdata('top_menu', 'setup');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('inner_menu', 'admin/roles');
        $this->form_validation->set_rules(
            'name', $this->lang->line('name'), array(
                'required',
                array('check_exists', array($this->role_model, 'valid_check_exists')),
            )
        );
        if ($this->form_validation->run() == false) {
            $listroute         = $this->role_model->get();
            $data['listroute'] = $listroute;
            $this->load->view('layout/header');
            $this->load->view('admin/roles/create', $data);
            $this->load->view('layout/footer');
        } else {
            $data = array(
                'name' => $this->input->post('name'),
            );
            $this->role_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/roles');
        }
    }

    public function permission($id, $open_tab = 0)
    {
        $data['title']           = $this->lang->line('add_role');
        $data['id']              = $id;
        $role                    = $this->role_model->get($id);
        $role_id                 = $role['id'];
        $data['role']            = $role;
        $data['open_tab']        = $open_tab;
        $role_permission         = $this->role_model->find($role['id']);
        $data['role_permission'] = $role_permission;
        if ($this->input->server('REQUEST_METHOD') == "POST") {

            $open_tab     = $this->input->post('open_tab');
            $per_cat_post = $this->input->post('per_cat');
            $role_id      = $this->input->post('role_id');
            $to_be_insert = array();
            $to_be_update = array();
            $to_be_delete = array();

            foreach ($per_cat_post as $per_cat_post_key => $per_cat_post_value) {
                $insert_data = array();
                $ar          = array();
                foreach ($this->perm_category as $per_key => $per_value) {
                    $chk_val = $this->input->post($per_value . "-perm_" . $per_cat_post_value);

                    if (isset($chk_val)) {
                        $insert_data[$per_value] = 1;
                    } else {
                        $ar[$per_value] = 0;
                    }
                }

                $prev_id = $this->input->post('roles_permissions_id_' . $per_cat_post_value);
                if ($prev_id != 0) {

                    if (!empty($insert_data)) {
                        $insert_data['id'] = $prev_id;
                        $to_be_update[]    = array_merge($ar, $insert_data);
                    } else {
                        $to_be_delete[] = $prev_id;
                    }
                } elseif (!empty($insert_data)) {
                    $insert_data['role_id']     = $role_id;
                    $insert_data['perm_cat_id'] = $per_cat_post_value;
                    $to_be_insert[]             = array_merge($ar, $insert_data);
                }

            }
            $this->role_model->getInsertBatch($role_id, $to_be_insert, $to_be_update, $to_be_delete);
			$this->session->set_flashdata('msg', '<div class="alert alert-success">' . $this->lang->line('success_message') . '</div>');
            redirect('admin/roles/permission/' . $id . "/" . $open_tab);
        }
 
        $this->load->view('layout/header');
        $this->load->view('admin/roles/allotmodule', $data);
        $this->load->view('layout/footer');
    }

    public function edit($id)
    {
        $data['title']    = $this->lang->line('edit_role');
        $data['id']       = $id;
        $editrole         = $this->role_model->get($id);
        $data['editrole'] = $editrole;
        $data['name']     = $editrole["name"];

        $this->form_validation->set_rules(
            'name', $this->lang->line('name'), array(
                'required',
                array('check_exists', array($this->role_model, 'valid_check_exists')),
            )
        );
        if ($this->form_validation->run() == false) {
            $listroute         = $this->role_model->get();
            $data['listroute'] = $listroute;
            $this->load->view('layout/header');
            $this->load->view('admin/roles/edit', $data);
            $this->load->view('layout/footer');
        } else {
            $data = array(
                'id'   => $id,
                'name' => $this->input->post('name'),
            );
            $this->role_model->add($data);
            $this->session->set_flashdata('msg', '<div class="alert alert-success text-left">' . $this->lang->line('update_message') . '</div>');
            redirect('admin/roles/index');
        }
    }

    public function delete($id)
    {
        $data['title'] = $this->lang->line('fees_master_list');
        $this->role_model->remove($id);
        echo json_encode(array('status' => 1, 'msg' => $this->lang->line('delete_message')));
    }
    
    /**
     * Roles & Permissions Manager
     * Advanced interface for managing roles and permissions
     */
    public function permissions_manager() 
    {
        // Set session data for menu navigation (similar to other methods)
        $this->session->set_userdata('top_menu', 'setup');
        $this->session->set_userdata('sub_menu', 'schsettings/index');
        $this->session->set_userdata('inner_menu', 'admin/roles');
        
        // Prepare data for the view
        $data['title'] = 'Roles & Permissions Manager';
        
        // Load necessary models if not already loaded
        $this->load->model('role_model');
        
        // Get all roles, permission groups, and categories for the interface
        $data['roles'] = $this->role_model->get();
        $data['permission_groups'] = $this->get_permission_groups();
        $data['permission_categories'] = $this->get_permission_categories();
        $data['role_permissions'] = $this->get_role_permissions();
        
        // Load the view
        $this->load->view('layout/header', $data);
        $this->load->view('admin/roles/permissions_manager', $data);
        $this->load->view('layout/footer');
    }
    
    /**
     * AJAX method to get permission groups
     */
    public function get_permission_groups() 
    {
        $this->db->select('*');
        $this->db->from('permission_group');
        $this->db->order_by('sort_order', 'ASC');
        $query = $this->db->get();
        
        if ($this->input->is_ajax_request()) {
            header('Content-Type: application/json');
            echo json_encode($query->result_array());
            return;
        }
        
        return $query->result_array();
    }
    
    /**
     * AJAX method to get permission categories
     */
    public function get_permission_categories() 
    {
        $this->db->select('pc.*, pg.name as group_name');
        $this->db->from('permission_category pc');
        $this->db->join('permission_group pg', 'pc.perm_group_id = pg.id', 'left');
        $this->db->order_by('pg.sort_order, pc.name', 'ASC');
        $query = $this->db->get();
        
        if ($this->input->is_ajax_request()) {
            header('Content-Type: application/json');
            echo json_encode($query->result_array());
            return;
        }
        
        return $query->result_array();
    }
    
    /**
     * AJAX method to get role permissions
     */
    public function get_role_permissions() 
    {
        $this->db->select('rp.*, r.name as role_name, pc.name as permission_name');
        $this->db->from('roles_permissions rp');
        $this->db->join('roles r', 'rp.role_id = r.id', 'left');
        $this->db->join('permission_category pc', 'rp.perm_cat_id = pc.id', 'left');
        $query = $this->db->get();
        
        if ($this->input->is_ajax_request()) {
            header('Content-Type: application/json');
            echo json_encode($query->result_array());
            return;
        }
        
        return $query->result_array();
    }
    
    /**
     * AJAX method to add new role
     */
    public function add_role() 
    {
        if ($this->input->is_ajax_request() && $this->input->server('REQUEST_METHOD') == "POST") {
            header('Content-Type: application/json');
            
            $data = array(
                'name' => $this->input->post('name'),
                'slug' => $this->input->post('slug'),
                'is_active' => $this->input->post('is_active') ? 1 : 0,
                'is_system' => $this->input->post('is_system') ? 1 : 0,
                'is_superadmin' => 0
            );
            
            $result = $this->role_model->add($data);
            
            if ($result) {
                echo json_encode(array(
                    'status' => 'success',
                    'message' => 'Role added successfully',
                    'role_id' => $result
                ));
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Failed to add role'
                ));
            }
        } else {
            show_404();
        }
    }
    
    /**
     * AJAX method to add permission group
     */
    public function add_permission_group() 
    {
        if ($this->input->is_ajax_request() && $this->input->server('REQUEST_METHOD') == "POST") {
            header('Content-Type: application/json');
            
            $data = array(
                'name' => $this->input->post('name'),
                'short_code' => $this->input->post('short_code'),
                'is_active' => 1,
                'system' => 0,
                'sort_order' => $this->input->post('sort_order')
            );
            
            $this->db->insert('permission_group', $data);
            $insert_id = $this->db->insert_id();
            
            if ($insert_id) {
                echo json_encode(array(
                    'status' => 'success',
                    'message' => 'Permission group added successfully',
                    'group_id' => $insert_id
                ));
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Failed to add permission group'
                ));
            }
        } else {
            show_404();
        }
    }
    
    /**
     * AJAX method to add permission category
     */
    public function add_permission_category() 
    {
        if ($this->input->is_ajax_request() && $this->input->server('REQUEST_METHOD') == "POST") {
            header('Content-Type: application/json');
            
            $data = array(
                'perm_group_id' => $this->input->post('perm_group_id'),
                'name' => $this->input->post('name'),
                'short_code' => $this->input->post('short_code'),
                'enable_view' => $this->input->post('enable_view') ? 1 : 0,
                'enable_add' => $this->input->post('enable_add') ? 1 : 0,
                'enable_edit' => $this->input->post('enable_edit') ? 1 : 0,
                'enable_delete' => $this->input->post('enable_delete') ? 1 : 0
            );
            
            $this->db->insert('permission_category', $data);
            $insert_id = $this->db->insert_id();
            
            if ($insert_id) {
                echo json_encode(array(
                    'status' => 'success',
                    'message' => 'Permission added successfully',
                    'permission_id' => $insert_id
                ));
            } else {
                echo json_encode(array(
                    'status' => 'error',
                    'message' => 'Failed to add permission'
                ));
            }
        } else {
            show_404();
        }
    }
    
    /**
     * AJAX method to save role permissions
     */
    public function save_role_permissions() 
    {
        if ($this->input->is_ajax_request() && $this->input->server('REQUEST_METHOD') == "POST") {
            header('Content-Type: application/json');
            
            $role_id = $this->input->post('role_id');
            $permissions = $this->input->post('permissions');
            
            // Delete existing permissions for this role
            $this->db->where('role_id', $role_id);
            $this->db->delete('roles_permissions');
            
            // Insert new permissions
            if (!empty($permissions)) {
                foreach ($permissions as $permission) {
                    $this->db->insert('roles_permissions', $permission);
                }
            }
            
            echo json_encode(array(
                'status' => 'success',
                'message' => 'Permissions saved successfully'
            ));
        } else {
            show_404();
        }
    }
}