<?php

defined('BASEPATH') or exit('No direct script access allowed');


function my_autoloader($class)
{

    if (substr($class, 0, 9) == "MY_Addon_") {
   
       if (file_exists($file = APPPATH . 'core/' . $class . '.php')) {
            include $file;
        }
    }
}
spl_autoload_register('my_autoloader');

$route['default_controller']                 = 'welcome/index';
$route['user/resetpassword/([a-z]+)/(:any)'] = 'site/resetpassword/$1/$2';
$route['admin/resetpassword/(:any)']         = 'site/admin_resetpassword/$1';
$route['admin/unauthorized']                 = 'admin/admin/unauthorized';
$route['404_override'] = 'welcome/show_404';
$route['translate_uri_dashes'] = false;
$route['form/appointment']     = 'welcome/appointment';
$route['page/annual_calendar']     = 'welcome/annual_calendar';

//======= front url rewriting==========
$route['page/(:any)'] = 'welcome/page/$1';
$route['read/(:any)'] = 'welcome/read/$1';
$route['frontend']    = 'welcome';

// =============================================
// NURSING MODULE ROUTES - COMPREHENSIVE
// =============================================

// Main Nursing Dashboard
$route['admin/nursing'] = 'admin/Nursing/index';
$route['admin/nursing/index'] = 'admin/Nursing/index';
$route['admin/nursing/dashboard'] = 'admin/Nursing/index';

// Patient Search and Management
$route['admin/nursing/searchPatients'] = 'admin/Nursing/searchPatients';
$route['admin/nursing/getPatientDetails'] = 'admin/Nursing/getPatientDetails';
$route['admin/nursing/patient_profile/(:num)'] = 'admin/Nursing/patient_profile/$1';
$route['admin/nursing/get_patient_info/(:num)'] = 'admin/Nursing/get_patient_info/$1';
$route['admin/nursing/patient_search'] = 'admin/Nursing/patient_search';

// Vital Signs Management
$route['admin/nursing/vital_signs'] = 'admin/Nursing/vital_signs';
$route['admin/nursing/vital_signs/(:num)'] = 'admin/Nursing/vital_signs/$1';
$route['admin/nursing/all_vital_signs'] = 'admin/Nursing/all_vital_signs';
$route['admin/nursing/add_vital_signs'] = 'admin/Nursing/add_vital_signs';
$route['admin/nursing/get_vital_signs/(:num)'] = 'admin/Nursing/get_vital_signs/$1';
$route['admin/nursing/get_vital_details'] = 'admin/Nursing/get_vital_details';
$route['admin/nursing/delete_vital_signs'] = 'admin/Nursing/delete_vital_signs';

// Nursing Notes Management
$route['admin/nursing/add_nurse_note'] = 'admin/Nursing/add_nurse_note';
$route['admin/nursing/getAllNursingNotes'] = 'admin/Nursing/getAllNursingNotes';
$route['admin/nursing/getNoteDetails'] = 'admin/Nursing/getNoteDetails';
$route['admin/nursing/getNursingStaff'] = 'admin/Nursing/getNursingStaff';

// Procedures Management
$route['admin/nursing/add_procedure'] = 'admin/Nursing/add_procedure';
$route['admin/nursing/get_procedure_templates'] = 'admin/Nursing/get_procedure_templates';
$route['admin/nursing/update_procedure_status'] = 'admin/Nursing/update_procedure_status';

// Assessments Management
$route['admin/nursing/add_assessment'] = 'admin/Nursing/add_assessment';

// Care Plans Management
$route['admin/nursing/create_care_plan'] = 'admin/Nursing/create_care_plan';

// Reports and Analytics
$route['admin/nursing/reports'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/daily'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/procedures'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/medication'] = 'admin/Nursing/reports';
$route['admin/nursing/reports/vital_signs'] = 'admin/Nursing/reports';

// Export Functionality
$route['admin/nursing/exportNursingNotes'] = 'admin/Nursing/exportNursingNotes';
$route['admin/nursing/exportVitalSigns'] = 'admin/Nursing/exportVitalSigns';
$route['admin/nursing/exportProcedures'] = 'admin/Nursing/exportProcedures';
$route['admin/nursing/exportAssessments'] = 'admin/Nursing/exportAssessments';

// Report Generation
$route['admin/nursing/generateDailyReport'] = 'admin/Nursing/generateDailyReport';
$route['admin/nursing/generateWeeklyReport'] = 'admin/Nursing/generateWeeklyReport';
$route['admin/nursing/generateMonthlyReport'] = 'admin/Nursing/generateMonthlyReport';

// Setup and Testing
$route['admin/nursing/setup'] = 'admin/Nursing/setup';
$route['admin/nursing/test'] = 'admin/Nursing/test';
$route['admin/nursing/debug_forms'] = 'admin/Nursing/debug_forms';
$route['admin/nursing/test_vital_signs'] = 'admin/Nursing/test_vital_signs';
$route['admin/nursing/test_nursing_note'] = 'admin/Nursing/test_nursing_note';

// Consultation routes
$route['admin/consultation'] = 'admin/consultation/index';
$route['admin/consultation/test'] = 'admin/consultation/test';
$route['admin/consultation/debug_patients'] = 'admin/consultation/debug_patients';
$route['admin/consultation/patient_search'] = 'admin/consultation/patient_search';
$route['admin/consultation/getAllPatients'] = 'admin/consultation/getAllPatients';
$route['admin/consultation/getPatientDetails'] = 'admin/consultation/getPatientDetails';
$route['admin/consultation/save'] = 'admin/consultation/save';
$route['admin/consultation/getConsultationList'] = 'admin/consultation/getConsultationList';
$route['admin/consultation/getPatientConsultations'] = 'admin/consultation/getPatientConsultations';

$route['admin/financial_reports'] = 'admin/financial_reports';
$route['admin/financial_reports/(:any)'] = 'admin/financial_reports/$1';

// Main procurement dashboard
$route['admin/procurement'] = 'admin/procurement/index';
$route['admin/procurement/dashboard'] = 'admin/procurement/index';

// =============================================
// REQUISITIONS ROUTES
// =============================================

// Requisitions management
$route['admin/procurement/requisitions'] = 'admin/procurement/requisitions';
$route['admin/procurement/requisitions/(:any)'] = 'admin/procurement/requisitions/$1';

// AJAX routes for requisitions
$route['admin/procurement/getRequisitionsList'] = 'admin/procurement/getRequisitionsList';
$route['admin/procurement/saveRequisition'] = 'admin/procurement/saveRequisition';
$route['admin/procurement/updateRequisition'] = 'admin/procurement/updateRequisition';
$route['admin/procurement/approveRequisition'] = 'admin/procurement/approveRequisition';
$route['admin/procurement/rejectRequisition'] = 'admin/procurement/rejectRequisition';
$route['admin/procurement/deleteRequisition/(:num)'] = 'admin/procurement/deleteRequisition/$1';

// Requisition details and items
$route['admin/procurement/viewRequisition/(:num)'] = 'admin/procurement/viewRequisition/$1';
$route['admin/procurement/getRequisitionItems/(:num)'] = 'admin/procurement/getRequisitionItems/$1';
$route['admin/procurement/printRequisition/(:num)'] = 'admin/procurement/printRequisition/$1';

// =============================================
// PURCHASE ORDERS (LPO) ROUTES
// =============================================

// Purchase orders management
$route['admin/procurement/purchaseOrders'] = 'admin/procurement/purchaseOrders';
$route['admin/procurement/purchase-orders'] = 'admin/procurement/purchaseOrders';
$route['admin/procurement/lpo'] = 'admin/procurement/purchaseOrders';

// AJAX routes for purchase orders
$route['admin/procurement/getPurchaseOrdersList'] = 'admin/procurement/getPurchaseOrdersList';
$route['admin/procurement/createLPOFromRequisition'] = 'admin/procurement/createLPOFromRequisition';
$route['admin/procurement/savePurchaseOrder'] = 'admin/procurement/savePurchaseOrder';
$route['admin/procurement/updatePurchaseOrder'] = 'admin/procurement/updatePurchaseOrder';
$route['admin/procurement/cancelPurchaseOrder/(:num)'] = 'admin/procurement/cancelPurchaseOrder/$1';

// Purchase order details and printing
$route['admin/procurement/viewLPO/(:num)'] = 'admin/procurement/viewLPO/$1';
$route['admin/procurement/printLPO/(:num)'] = 'admin/procurement/printLPO/$1';
$route['admin/procurement/emailLPO/(:num)'] = 'admin/procurement/emailLPO/$1';
$route['admin/procurement/downloadLPO/(:num)'] = 'admin/procurement/downloadLPO/$1';

// LPO status updates
$route['admin/procurement/markLPOSent/(:num)'] = 'admin/procurement/markLPOSent/$1';
$route['admin/procurement/confirmLPO/(:num)'] = 'admin/procurement/confirmLPO/$1';

// =============================================
// GOODS RECEIVED NOTES (GRN) ROUTES
// =============================================

// GRN management
$route['admin/procurement/goodsReceived'] = 'admin/procurement/goodsReceived';
$route['admin/procurement/goods-received'] = 'admin/procurement/goodsReceived';
$route['admin/procurement/grn'] = 'admin/procurement/goodsReceived';

// AJAX routes for GRN
$route['admin/procurement/getGRNList'] = 'admin/procurement/getGRNList';
$route['admin/procurement/createGRN'] = 'admin/procurement/createGRN';
$route['admin/procurement/saveGRN'] = 'admin/procurement/saveGRN';
$route['admin/procurement/updateGRN'] = 'admin/procurement/updateGRN';

// GRN details and printing
$route['admin/procurement/viewGRN/(:num)'] = 'admin/procurement/viewGRN/$1';
$route['admin/procurement/printGRN/(:num)'] = 'admin/procurement/printGRN/$1';
$route['admin/procurement/getPOItemsForGRN/(:num)'] = 'admin/procurement/getPOItemsForGRN/$1';

// Quality control and verification
$route['admin/procurement/verifyGRN/(:num)'] = 'admin/procurement/verifyGRN/$1';
$route['admin/procurement/postGRN/(:num)'] = 'admin/procurement/postGRN/$1';

// =============================================
// SUPPLIERS MANAGEMENT ROUTES
// =============================================

// Suppliers management
$route['admin/procurement/suppliers'] = 'admin/procurement/suppliers';
$route['admin/procurement/vendors'] = 'admin/procurement/suppliers';

// AJAX routes for suppliers
$route['admin/procurement/getSuppliersList'] = 'admin/procurement/getSuppliersList';
$route['admin/procurement/saveSupplier'] = 'admin/procurement/saveSupplier';
$route['admin/procurement/updateSupplier'] = 'admin/procurement/updateSupplier';
$route['admin/procurement/deleteSupplier/(:num)'] = 'admin/procurement/deleteSupplier/$1';

// Supplier details
$route['admin/procurement/viewSupplier/(:num)'] = 'admin/procurement/viewSupplier/$1';
$route['admin/procurement/getSupplierDetails/(:num)'] = 'admin/procurement/getSupplierDetails/$1';
$route['admin/procurement/searchSuppliers'] = 'admin/procurement/searchSuppliers';

// Supplier performance and evaluation
$route['admin/procurement/supplierPerformance/(:num)'] = 'admin/procurement/supplierPerformance/$1';
$route['admin/procurement/evaluateSupplier/(:num)'] = 'admin/procurement/evaluateSupplier/$1';

// =============================================
// ITEMS/PRODUCTS MANAGEMENT ROUTES
// =============================================

// Items management
$route['admin/procurement/items'] = 'admin/procurement/items';
$route['admin/procurement/products'] = 'admin/procurement/items';
$route['admin/procurement/inventory'] = 'admin/procurement/items';

// AJAX routes for items
$route['admin/procurement/getItemsList'] = 'admin/procurement/getItemsList';
$route['admin/procurement/saveItem'] = 'admin/procurement/saveItem';
$route['admin/procurement/updateItem'] = 'admin/procurement/updateItem';
$route['admin/procurement/deleteItem/(:num)'] = 'admin/procurement/deleteItem/$1';

// Item details and search
$route['admin/procurement/viewItem/(:num)'] = 'admin/procurement/viewItem/$1';
$route['admin/procurement/getItemDetails/(:num)'] = 'admin/procurement/getItemDetails/$1';
$route['admin/procurement/searchItems'] = 'admin/procurement/searchItems';
$route['admin/procurement/getItemsForSelect'] = 'admin/procurement/getItemsForSelect';

// Item categories
$route['admin/procurement/categories'] = 'admin/procurement/categories';
$route['admin/procurement/itemCategories'] = 'admin/procurement/categories';
$route['admin/procurement/getCategoriesList'] = 'admin/procurement/getCategoriesList';
$route['admin/procurement/saveCategory'] = 'admin/procurement/saveCategory';

// Stock management
$route['admin/procurement/stockReport'] = 'admin/procurement/stockReport';
$route['admin/procurement/lowStockItems'] = 'admin/procurement/lowStockItems';
$route['admin/procurement/stockMovement'] = 'admin/procurement/stockMovement';
$route['admin/procurement/updateStock'] = 'admin/procurement/updateStock';

// =============================================
// BUDGET AND FINANCIAL ROUTES
// =============================================

// Budget management
$route['admin/procurement/budgets'] = 'admin/procurement/budgets';
$route['admin/procurement/budget-tracking'] = 'admin/procurement/budgets';

// AJAX routes for budgets
$route['admin/procurement/getBudgetsList'] = 'admin/procurement/getBudgetsList';
$route['admin/procurement/saveBudget'] = 'admin/procurement/saveBudget';
$route['admin/procurement/updateBudget'] = 'admin/procurement/updateBudget';
$route['admin/procurement/getBudgetUtilization'] = 'admin/procurement/getBudgetUtilization';

// Financial tracking
$route['admin/procurement/commitBudget'] = 'admin/procurement/commitBudget';
$route['admin/procurement/releaseBudget'] = 'admin/procurement/releaseBudget';
$route['admin/procurement/budgetReport'] = 'admin/procurement/budgetReport';

// =============================================
// APPROVAL WORKFLOW ROUTES
// =============================================

// Approval management
$route['admin/procurement/approvals'] = 'admin/procurement/approvals';
$route['admin/procurement/workflow'] = 'admin/procurement/approvals';

// AJAX routes for approvals
$route['admin/procurement/getPendingApprovals'] = 'admin/procurement/getPendingApprovals';
$route['admin/procurement/processApproval'] = 'admin/procurement/processApproval';
$route['admin/procurement/getApprovalHistory/(:any)/(:num)'] = 'admin/procurement/getApprovalHistory/$1/$2';

// Approval workflow configuration
$route['admin/procurement/approvalSettings'] = 'admin/procurement/approvalSettings';
$route['admin/procurement/setApprovalLimits'] = 'admin/procurement/setApprovalLimits';

// =============================================
// REPORTS AND ANALYTICS ROUTES
// =============================================

// Reports dashboard
$route['admin/procurement/reports'] = 'admin/procurement/reports';
$route['admin/procurement/analytics'] = 'admin/procurement/reports';

// Specific reports
$route['admin/procurement/procurementReport'] = 'admin/procurement/procurementReport';
$route['admin/procurement/requisitionReport'] = 'admin/procurement/requisitionReport';
$route['admin/procurement/purchaseOrderReport'] = 'admin/procurement/purchaseOrderReport';
$route['admin/procurement/supplierReport'] = 'admin/procurement/supplierReport';
$route['admin/procurement/spendAnalysis'] = 'admin/procurement/spendAnalysis';
$route['admin/procurement/complianceReport'] = 'admin/procurement/complianceReport';

// Report generation
$route['admin/procurement/generateReport'] = 'admin/procurement/generateReport';
$route['admin/procurement/exportReport/(:any)'] = 'admin/procurement/exportReport/$1';
$route['admin/procurement/downloadReport/(:any)'] = 'admin/procurement/downloadReport/$1';

// =============================================
// SETTINGS AND CONFIGURATION ROUTES
// =============================================

// Procurement settings
$route['admin/procurement/settings'] = 'admin/procurement/settings';
$route['admin/procurement/configuration'] = 'admin/procurement/settings';

// Settings management
$route['admin/procurement/updateSettings'] = 'admin/procurement/updateSettings';
$route['admin/procurement/resetSettings'] = 'admin/procurement/resetSettings';

// Number sequences and prefixes
$route['admin/procurement/numberSequences'] = 'admin/procurement/numberSequences';
$route['admin/procurement/updateSequence'] = 'admin/procurement/updateSequence';

// =============================================
// API ROUTES FOR MOBILE/EXTERNAL ACCESS
// =============================================

// API authentication
$route['api/procurement/auth'] = 'api/procurement/authenticate';
$route['api/procurement/login'] = 'api/procurement/authenticate';

// API data endpoints
$route['api/procurement/requisitions'] = 'api/procurement/getRequisitions';
$route['api/procurement/purchase-orders'] = 'api/procurement/getPurchaseOrders';
$route['api/procurement/suppliers'] = 'api/procurement/getSuppliers';
$route['api/procurement/items'] = 'api/procurement/getItems';

// API operations
$route['api/procurement/create-requisition'] = 'api/procurement/createRequisition';
$route['api/procurement/approve-requisition/(:num)'] = 'api/procurement/approveRequisition/$1';
$route['api/procurement/receive-goods'] = 'api/procurement/receiveGoods';

// =============================================
// DASHBOARD AND WIDGET ROUTES
// =============================================

// Dashboard widgets
$route['admin/procurement/getDashboardStats'] = 'admin/procurement/getDashboardStats';
$route['admin/procurement/getRecentActivity'] = 'admin/procurement/getRecentActivity';
$route['admin/procurement/getPendingItems'] = 'admin/procurement/getPendingItems';
$route['admin/procurement/getBudgetWidget'] = 'admin/procurement/getBudgetWidget';

// Chart data
$route['admin/procurement/getSpendingChart'] = 'admin/procurement/getSpendingChart';
$route['admin/procurement/getSupplierChart'] = 'admin/procurement/getSupplierChart';
$route['admin/procurement/getCategoryChart'] = 'admin/procurement/getCategoryChart';

// =============================================
// INTEGRATION ROUTES
// =============================================

// Finance system integration
$route['admin/procurement/syncWithFinance'] = 'admin/procurement/syncWithFinance';
$route['admin/procurement/postToAccounting'] = 'admin/procurement/postToAccounting';

// Inventory system integration
$route['admin/procurement/syncWithInventory'] = 'admin/procurement/syncWithInventory';
$route['admin/procurement/updateInventoryLevels'] = 'admin/procurement/updateInventoryLevels';

// External system webhooks
$route['webhook/procurement/supplier-update'] = 'webhook/procurement/handleSupplierUpdate';
$route['webhook/procurement/price-update'] = 'webhook/procurement/handlePriceUpdate';

// =============================================
// UTILITY AND HELPER ROUTES
// =============================================

// Autocomplete and search
$route['admin/procurement/autocomplete/items'] = 'admin/procurement/autocompleteItems';
$route['admin/procurement/autocomplete/suppliers'] = 'admin/procurement/autocompleteSuppliers';
$route['admin/procurement/search/(:any)'] = 'admin/procurement/globalSearch/$1';

// File uploads and downloads
$route['admin/procurement/uploadFile'] = 'admin/procurement/uploadFile';
$route['admin/procurement/downloadTemplate/(:any)'] = 'admin/procurement/downloadTemplate/$1';
$route['admin/procurement/importData'] = 'admin/procurement/importData';

// Validation and checks
$route['admin/procurement/validateData'] = 'admin/procurement/validateData';
$route['admin/procurement/checkDuplicates'] = 'admin/procurement/checkDuplicates';
$route['admin/procurement/verifyBudget'] = 'admin/procurement/verifyBudget';

// =============================================
// AUDIT AND LOGGING ROUTES
// =============================================

// Audit trail
$route['admin/procurement/auditTrail'] = 'admin/procurement/auditTrail';
$route['admin/procurement/getAuditLogs'] = 'admin/procurement/getAuditLogs';
$route['admin/procurement/viewAuditDetails/(:num)'] = 'admin/procurement/viewAuditDetails/$1';

// Activity logging
$route['admin/procurement/logActivity'] = 'admin/procurement/logActivity';
$route['admin/procurement/getUserActivity/(:num)'] = 'admin/procurement/getUserActivity/$1';

// =============================================
// NOTIFICATIONS AND ALERTS ROUTES
// =============================================

// Notification management
$route['admin/procurement/notifications'] = 'admin/procurement/notifications';
$route['admin/procurement/getNotifications'] = 'admin/procurement/getNotifications';
$route['admin/procurement/markNotificationRead/(:num)'] = 'admin/procurement/markNotificationRead/$1';

// Alert settings
$route['admin/procurement/alertSettings'] = 'admin/procurement/alertSettings';
$route['admin/procurement/updateAlerts'] = 'admin/procurement/updateAlerts';

// Email notifications
$route['admin/procurement/sendEmailNotification'] = 'admin/procurement/sendEmailNotification';
$route['admin/procurement/emailTemplates'] = 'admin/procurement/emailTemplates';

// =============================================
// BACKUP AND MAINTENANCE ROUTES
// =============================================

// Data backup
$route['admin/procurement/backup'] = 'admin/procurement/backup';
$route['admin/procurement/createBackup'] = 'admin/procurement/createBackup';
$route['admin/procurement/restoreBackup'] = 'admin/procurement/restoreBackup';

// System maintenance
$route['admin/procurement/maintenance'] = 'admin/procurement/maintenance';
$route['admin/procurement/clearCache'] = 'admin/procurement/clearCache';
$route['admin/procurement/optimizeDatabase'] = 'admin/procurement/optimizeDatabase';

// Ensure the route exists
$route['admin/financial/dashboard'] = 'admin/financial/dashboard';
$route['admin/financial/(.+)'] = 'admin/financial/$1';

$route['admin/radio/gettestreportbatch'] = 'radio/gettestreportbatch';

// Patient Billing Routes
$route['admin/patient_billing'] = 'admin/patient_billing/index';
$route['admin/patient_billing/search'] = 'admin/patient_billing/search_patients';
$route['admin/patient_billing/billing/(:num)'] = 'admin/patient_billing/get_billing/$1';
$route['admin/patient_billing/details/(:any)'] = 'admin/patient_billing/get_bill_details/$1';
$route['admin/patient_billing/payment'] = 'admin/patient_billing/process_payment';
$route['admin/patient_billing/export/(:num)'] = 'admin/patient_billing/export_csv/$1';
$route['admin/patient_billing/print/(:num)'] = 'admin/patient_billing/print_statement/$1';

// Alternative direct routes (if API-style doesn't work)
$route['admin/billing/search'] = 'admin/patient_billing/direct_search';
$route['admin/billing/view/(:num)'] = 'admin/patient_billing/view_billing/$1';

$route['admin/laboratory/import-excel'] = 'admin/laboratory/importExcelData';
$route['admin/laboratory/setup-lab-system'] = 'admin/laboratory/setupLabSystem';
$route['admin/laboratory/test-selection'] = 'admin/laboratory/testSelection';
$route['admin/laboratory/results'] = 'admin/laboratory/results';
$route['admin/laboratory/print_result'] = 'admin/laboratory/print_result';

// Main radiology routes
$route['admin/radiology'] = 'admin/radiology/index';
$route['admin/radiology/index'] = 'admin/radiology/index';

// Patient management routes
$route['admin/radiology/getAllPatients'] = 'admin/radiology/getAllPatients';
$route['admin/radiology/getPatientDetails'] = 'admin/radiology/getPatientDetails';
$route['admin/radiology/verifyPatientIdentity'] = 'admin/radiology/verifyPatientIdentity';

// Order management routes
$route['admin/radiology/createRadiologyOrder'] = 'admin/radiology/createRadiologyOrder';
$route['admin/radiology/getRadiologyQueue'] = 'admin/radiology/getRadiologyQueue';
$route['admin/radiology/updateOrderStatus'] = 'admin/radiology/updateOrderStatus';
$route['admin/radiology/getOrderDetails'] = 'admin/radiology/getOrderDetails';

// Reporting and analytics routes
$route['admin/radiology/reports'] = 'admin/radiology/reports';
$route['admin/radiology/statistics'] = 'admin/radiology/statistics';
$route['admin/radiology/generateReport'] = 'admin/radiology/generateReport';

// Equipment management routes
$route['admin/radiology/equipment'] = 'admin/radiology/equipment';
$route['admin/radiology/equipmentStatus'] = 'admin/radiology/equipmentStatus';

// Scheduling routes
$route['admin/radiology/schedule'] = 'admin/radiology/schedule';
$route['admin/radiology/scheduleAppointment'] = 'admin/radiology/scheduleAppointment';
$route['admin/radiology/getSchedule'] = 'admin/radiology/getSchedule';

// Test routes
$route['admin/radiology/test'] = 'admin/radiology/test';

$route['admin/patient_billing'] = 'admin/patient_billing/index';
$route['admin/patient_billing/(:any)'] = 'admin/patient_billing/$1';

// Main pharmacy dashboard (landing page)
$route['admin/pharmacy'] = 'admin/pharmacy/dashboard';
$route['admin/pharmacy/dashboard'] = 'admin/pharmacy/dashboard';

// Keep original medicine stock page accessible
$route['admin/pharmacy/stock'] = 'admin/pharmacy/medicineStock';

// Dashboard and analytics routes
$route['admin/pharmacy/getDashboardStats'] = 'admin/pharmacy/getDashboardStats';
$route['admin/pharmacy/getRecentBills'] = 'admin/pharmacy/getRecentBills';
$route['admin/pharmacy/getPharmacyAlerts'] = 'admin/pharmacy/getPharmacyAlerts';
$route['admin/pharmacy/getStockAlertsCount'] = 'admin/pharmacy/getStockAlertsCount';

// Patient-related pharmacy routes
$route['admin/pharmacy/getPatientBills'] = 'admin/pharmacy/getPatientBills';
$route['admin/pharmacy/getPatientPendingBills'] = 'admin/pharmacy/getPatientPendingBills';
$route['admin/pharmacy/getPatientPharmacySummary'] = 'admin/pharmacy/getPatientPharmacySummary';

// Medicine search and dispensing routes
$route['admin/pharmacy/searchMedicinesForDispensing'] = 'admin/pharmacy/searchMedicinesForDispensing';
$route['admin/pharmacy/quickDispense'] = 'admin/pharmacy/quickDispense';
$route['admin/pharmacy/processQuickDispensing'] = 'admin/pharmacy/processQuickDispensing';
$route['admin/pharmacy/quickMedicineLookup'] = 'admin/pharmacy/quickMedicineLookup';

// Stock management routes
$route['admin/pharmacy/getLowStockMedicines'] = 'admin/pharmacy/getLowStockMedicines';
$route['admin/pharmacy/getExpiredMedicines'] = 'admin/pharmacy/getExpiredMedicines';
$route['admin/pharmacy/getMedicinesExpiringSoon'] = 'admin/pharmacy/getMedicinesExpiringSoon';

// Enhanced bill creation
$route['admin/pharmacy/createBillEnhanced'] = 'admin/pharmacy/createBillEnhanced';

// Analytics and reporting routes
$route['admin/pharmacy/getTopSellingMedicines'] = 'admin/pharmacy/getTopSellingMedicines';
$route['admin/pharmacy/getSalesChartData'] = 'admin/pharmacy/getSalesChartData';
$route['admin/pharmacy/getPerformanceMetrics'] = 'admin/pharmacy/getPerformanceMetrics';
$route['admin/pharmacy/getInventoryValuation'] = 'admin/pharmacy/getInventoryValuation';
$route['admin/pharmacy/getMedicineUsageAnalytics'] = 'admin/pharmacy/getMedicineUsageAnalytics';

// Medicine interaction and workflow routes
$route['admin/pharmacy/checkMedicineInteractions'] = 'admin/pharmacy/checkMedicineInteractions';
$route['admin/pharmacy/getPharmacyWorkflow'] = 'admin/pharmacy/getPharmacyWorkflow';

// Payment processing routes (if implementing bulk payments)
$route['admin/pharmacy/processBulkPayment'] = 'admin/pharmacy/processBulkPayment';
$route['admin/pharmacy/processPartialPayment'] = 'admin/pharmacy/processPartialPayment';
$route['admin/pharmacy/sendPaymentReminder'] = 'admin/pharmacy/sendPaymentReminder';
$route['admin/pharmacy/sendBulkReminders'] = 'admin/pharmacy/sendBulkReminders';

// Enhanced datatable route (if replacing the original)
$route['admin/pharmacy/getpharmacyDatatableEnhanced'] = 'admin/pharmacy/getpharmacyDatatableEnhanced';

// =============================================================================
// PATIENT MODULE ROUTES (for pharmacy integration)
// =============================================================================

// Patient search routes for pharmacy
$route['admin/patient/searchPatients'] = 'admin/patient/searchPatients';
$route['admin/patient/getPatientForPharmacy'] = 'admin/patient/getPatientForPharmacy';

// =============================================================================
// OPTIONAL: URL ALIASES FOR BETTER UX
// =============================================================================

// Friendly URLs for common pharmacy operations
$route['pharmacy'] = 'admin/pharmacy/dashboard';
$route['pharmacy/dashboard'] = 'admin/pharmacy/dashboard';
$route['pharmacy/stock'] = 'admin/pharmacy/medicineStock';
$route['pharmacy/bills'] = 'admin/pharmacy/bill';
$route['pharmacy/reports'] = 'admin/pharmacy/billreport';

// Patient profile route
$route['admin/patient/profile/(:num)'] = 'admin/patient/profile/$1';

// Alternative routes for patient management
$route['admin/patient/view/(:num)'] = 'admin/patient/profile/$1';
$route['admin/patient/details/(:num)'] = 'admin/patient/profile/$1';

// If you want to make it even cleaner, you can also add:
$route['patient/(:num)'] = 'admin/patient/profile/$1';

// Radiology Routes - Fix the controller path
// Dashboard Routes
$route['admin/radiology/dashboard'] = 'admin/radiology/index';

// Order Management Routes
$route['admin/radiology/orders'] = 'admin/radiology/orders';
$route['admin/radiology/view_order/(:num)'] = 'admin/radiology/view_order/$1';
$route['admin/radiology/verify_order/(:num)'] = 'admin/radiology/verify_order/$1';
$route['admin/radiology/start_exam/(:num)'] = 'admin/radiology/start_exam/$1';
$route['admin/radiology/process_order_verification'] = 'admin/radiology/process_order_verification';

// Schedule Management Routes
$route['admin/radiology/schedule'] = 'admin/radiology/schedule';
$route['admin/radiology/view_appointment/(:num)'] = 'admin/radiology/view_appointment/$1';

// Reports Routes
$route['admin/radiology/reports'] = 'admin/radiology/reports';

// Patient Verification Interface (separate from dashboard)
$route['admin/radiology/patient_verification'] = 'admin/radiology/patient_verification';

// API Endpoints
$route['admin/radiology/get_patients'] = 'admin/radiology/get_patients';
$route['admin/radiology/verify_patient'] = 'admin/radiology/verify_patient';
$route['admin/radiology/create_order'] = 'admin/radiology/create_order';
$route['admin/radiology/getStoredFingerprintTemplate'] = 'admin/radiology/getStoredFingerprintTemplate';

// Accounting Integration Routes
$route['admin/radiology/recordRadiologyPayment'] = 'admin/radiology/recordRadiologyPayment';
$route['admin/radiology/processRadiologyRefund'] = 'admin/radiology/processRadiologyRefund';
$route['admin/radiology/getRadiologyAccountingReport'] = 'admin/radiology/getRadiologyAccountingReport';
$route['admin/radiology/debug_accounting_setup'] = 'admin/radiology/debug_accounting_setup';
$route['admin/radiology/setupRadiologyAccounts'] = 'admin/radiology/setupRadiologyAccounts';

// Debug and Test Routes
$route['admin/radiology/test'] = 'admin/radiology/test';
$route['admin/radiology/debug_table_structure'] = 'admin/radiology/debug_table_structure';

// Default radiology route - MUST BE LAST!
$route['admin/radiology'] = 'admin/radiology/index';

// Main radiology setup page
$route['admin/radiology-setup'] = 'admin/radiology_setup/index';
$route['admin/radiology-setup/index'] = 'admin/radiology_setup/index';

// DataTables AJAX endpoint
$route['admin/radiology-setup/get-tests-datatable'] = 'admin/radiology_setup/get_radiology_tests_datatable';

// CRUD Operations
$route['admin/radiology-setup/add-test'] = 'admin/radiology_setup/add_radiology_test';
$route['admin/radiology-setup/edit-test/(:num)'] = 'admin/radiology_setup/edit_radiology_test/$1';
$route['admin/radiology-setup/update-test'] = 'admin/radiology_setup/update_radiology_test';
$route['admin/radiology-setup/view-test/(:num)'] = 'admin/radiology_setup/view_radiology_test/$1';
$route['admin/radiology-setup/delete-test/(:num)'] = 'admin/radiology_setup/delete_radiology_test/$1';

// Test routes for debugging
$route['admin/radiology-setup/test'] = 'admin/radiology_setup/test';
$route['admin/radiology-setup/test-update'] = 'admin/radiology_setup/test_update';

// Status management
$route['admin/radiology-setup/toggle-status'] = 'admin/radiology_setup/toggle_test_status';
$route['admin/radiology-setup/toggle-gcc-status'] = 'admin/radiology_setup/toggle_gcc_status';
$route['admin/radiology-setup/bulk-toggle-status'] = 'admin/radiology_setup/bulk_toggle_status';

// GCC specific routes
$route['admin/radiology-setup/get-gcc-tests'] = 'admin/radiology_setup/get_gcc_tests';
$route['admin/radiology-setup/get-gcc-packages'] = 'admin/radiology_setup/get_gcc_packages';

// Export functionality
$route['admin/radiology-setup/export'] = 'admin/radiology_setup/export_radiology_tests';

// Test/Debug route
$route['admin/radiology-setup/test'] = 'admin/radiology_setup/test';

// Main specialized services routes
$route['admin/specialized_services'] = 'admin/specialized_services/dashboard';
$route['admin/specialized_services/dashboard'] = 'admin/specialized_services/dashboard';
$route['admin/specialized_services/services'] = 'admin/specialized_services/services';
$route['admin/specialized_services/categories'] = 'admin/specialized_services/categories';

// AJAX endpoints for services management
$route['admin/specialized_services/get_services_datatable'] = 'admin/specialized_services/get_services_datatable';
$route['admin/specialized_services/add_service'] = 'admin/specialized_services/add_service';
$route['admin/specialized_services/edit_service/(:num)'] = 'admin/specialized_services/edit_service/$1';
$route['admin/specialized_services/view_service/(:num)'] = 'admin/specialized_services/view_service/$1';
$route['admin/specialized_services/delete_service/(:num)'] = 'admin/specialized_services/delete_service/$1';

// Specialist requirement toggle
$route['admin/specialized_services/toggle_specialist_requirement'] = 'admin/specialized_services/toggle_specialist_requirement';

// Categories management
$route['admin/specialized_services/add_category'] = 'admin/specialized_services/add_category';
$route['admin/specialized_services/edit_category/(:num)'] = 'admin/specialized_services/edit_category/$1';
$route['admin/specialized_services/update_category/(:num)'] = 'admin/specialized_services/update_category/$1';
$route['admin/specialized_services/delete_category/(:num)'] = 'admin/specialized_services/delete_category/$1';

// API endpoints for getting data
$route['admin/specialized_services/get_categories'] = 'admin/specialized_services/get_categories';
$route['admin/specialized_services/get_services_by_type/(:alpha)'] = 'admin/specialized_services/get_services_by_type/$1';
$route['admin/specialized_services/search_services'] = 'admin/specialized_services/search_services';

// Dental specific routes
$route['admin/specialized_services/dental'] = 'admin/specialized_services/services';
$route['admin/specialized_services/dental/services'] = 'admin/specialized_services/get_services_by_type/dental';

// Optical specific routes
$route['admin/specialized_services/optical'] = 'admin/specialized_services/services';
$route['admin/specialized_services/optical/services'] = 'admin/specialized_services/get_services_by_type/optical';

// Setup and maintenance routes
$route['admin/specialized_services/setup_system'] = 'admin/specialized_services/setup_system';
$route['admin/specialized_services/debug_database'] = 'admin/specialized_services/debug_database';
$route['admin/specialized_services/test_endpoint'] = 'admin/specialized_services/test_endpoint';

// Bulk operations
$route['admin/specialized_services/bulk_update_services'] = 'admin/specialized_services/bulk_update_services';
$route['admin/specialized_services/bulk_toggle_status'] = 'admin/specialized_services/bulk_toggle_status';
$route['admin/specialized_services/bulk_toggle_specialist'] = 'admin/specialized_services/bulk_toggle_specialist';

// Import/Export routes
$route['admin/specialized_services/export_services'] = 'admin/specialized_services/export_services';
$route['admin/specialized_services/import_services'] = 'admin/specialized_services/import_services';

// Pricing and statistics
$route['admin/specialized_services/get_service_pricing/(:num)'] = 'admin/specialized_services/get_service_pricing/$1';
$route['admin/specialized_services/get_setup_stats'] = 'admin/specialized_services/get_setup_stats';

// Equipment management (if you want to add equipment tracking)
$route['admin/specialized_services/equipment'] = 'admin/specialized_services/equipment';
$route['admin/specialized_services/add_equipment'] = 'admin/specialized_services/add_equipment';
$route['admin/specialized_services/edit_equipment/(:num)'] = 'admin/specialized_services/edit_equipment/$1';

// Main triage records page
$route['admin/triage/records'] = 'admin/triage/triageRecords';
$route['admin/triage/triage-records'] = 'admin/triage/triageRecords';

// DataTables and AJAX endpoints
$route['admin/triage/list'] = 'admin/triage/getTriageList';
$route['admin/triage/get-triage-list'] = 'admin/triage/getTriageList';

// Statistics and dashboard data
$route['admin/triage/statistics'] = 'admin/triage/getTriageStatistics';
$route['admin/triage/stats'] = 'admin/triage/getTriageStatistics';

// Individual record operations
$route['admin/triage/details/(:num)'] = 'admin/triage/getTriageDetails/$1';
$route['admin/triage/view/(:num)'] = 'admin/triage/getTriageDetails/$1';

// Print and export functionality
$route['admin/triage/print/(:num)'] = 'admin/triage/printTriageRecord/$1';
$route['admin/triage/export'] = 'admin/triage/exportTriageRecords';
$route['admin/triage/export-csv'] = 'admin/triage/exportTriageRecords';

$route['admin/patient/view_patient_financials/(:num)'] = 'patient/view_patient_financials/$1';

// Main phlebotomy pages
$route['admin/phlebotomy'] = 'admin/phlebotomy/index';
$route['admin/phlebotomy/index'] = 'admin/phlebotomy/index';

// Patient management routes
$route['admin/phlebotomy/getTriagePatients'] = 'admin/phlebotomy/getTriagePatients';
$route['admin/phlebotomy/getTriageDetails'] = 'admin/phlebotomy/getTriageDetails';
$route['admin/phlebotomy/verifyPatientIdentity'] = 'admin/phlebotomy/verifyPatientIdentity';

// Sample collection routes
$route['admin/phlebotomy/saveSampleCollection'] = 'admin/phlebotomy/saveSampleCollection';
$route['admin/phlebotomy/getSampleHistory'] = 'admin/phlebotomy/getSampleHistory';
$route['admin/phlebotomy/updateSampleStatus'] = 'admin/phlebotomy/updateSampleStatus';

// Barcode management routes
$route['admin/phlebotomy/generateBarcodes'] = 'admin/phlebotomy/generateBarcodes';
$route['admin/phlebotomy/getBarcodeInfo'] = 'admin/phlebotomy/getBarcodeInfo';
$route['admin/phlebotomy/printBarcode/(:any)'] = 'admin/phlebotomy/printBarcode/$1';

// Process completion routes
$route['admin/phlebotomy/completeProcess'] = 'admin/phlebotomy/completeProcess';
$route['admin/phlebotomy/getProcessStatus'] = 'admin/phlebotomy/getProcessStatus';

// Reporting routes
$route['admin/phlebotomy/reports'] = 'admin/phlebotomy/reports';
$route['admin/phlebotomy/getPhlebotomyReports'] = 'admin/phlebotomy/getPhlebotomyReports';
$route['admin/phlebotomy/exportReport/(:any)'] = 'admin/phlebotomy/exportReport/$1';

// API routes for mobile/external access
$route['api/phlebotomy/validateBarcode/(:any)'] = 'api/phlebotomy/validateBarcode/$1';
$route['api/phlebotomy/updateSampleStatus'] = 'api/phlebotomy/updateSampleStatus';

$route['admin/queue'] = 'admin/queue/index';
$route['admin/queue/department/(:any)'] = 'admin/queue/department/$1';
$route['admin/queue/display/(:any)'] = 'admin/queue/display/$1';
$route['admin/queue/config'] = 'admin/queue/config';
$route['admin/queue/config/(:any)'] = 'admin/queue/config/$1';

// Add these routes to your routes.php file
$route['admin/pharma'] = 'admin/pharma/index';
$route['admin/pharma/(:any)'] = 'admin/pharma/$1';

// Medical Dispensary Routes
$route['admin/dispensary'] = 'admin/dispensary/index';
$route['admin/dispensary/dashboard'] = 'admin/dispensary/index';
$route['admin/dispensary/medicineStock'] = 'admin/dispensary/medicineStock';
$route['admin/dispensary/dispensing'] = 'admin/dispensary/dispensing';
$route['admin/dispensary/reports'] = 'admin/dispensary/reports';
$route['admin/dispensary/settings'] = 'admin/dispensary/settings';

// AJAX endpoints
$route['admin/dispensary/searchPatient'] = 'admin/dispensary/searchPatient';
$route['admin/dispensary/getPatientDetails'] = 'admin/dispensary/getPatientDetails';
$route['admin/dispensary/searchMedicine'] = 'admin/dispensary/searchMedicine';
$route['admin/dispensary/getMedicineDetails'] = 'admin/dispensary/getMedicineDetails';
$route['admin/dispensary/processBill'] = 'admin/dispensary/processBill';
$route['admin/dispensary/printBill/(:num)'] = 'admin/dispensary/printBill/$1';

// Reports endpoints
$route['admin/dispensary/getSalesReport'] = 'admin/dispensary/getSalesReport';
$route['admin/dispensary/getDetailedReport'] = 'admin/dispensary/getDetailedReport';
$route['admin/dispensary/getTopMedicines'] = 'admin/dispensary/getTopMedicines';
$route['admin/dispensary/getCriticalStock'] = 'admin/dispensary/getCriticalStock';
$route['admin/dispensary/getExpiryAlerts'] = 'admin/dispensary/getExpiryAlerts';
$route['admin/dispensary/getFinancialSummary'] = 'admin/dispensary/getFinancialSummary';
$route['admin/dispensary/getSalesTrend'] = 'admin/dispensary/getSalesTrend';
$route['admin/dispensary/getChartData'] = 'admin/dispensary/getChartData';
$route['admin/dispensary/exportReport'] = 'admin/dispensary/exportReport';

// Settings endpoints
$route['admin/dispensary/getSystemInfo'] = 'admin/dispensary/getSystemInfo';
$route['admin/dispensary/getSettings'] = 'admin/dispensary/getSettings';
$route['admin/dispensary/saveSettings'] = 'admin/dispensary/saveSettings';
$route['admin/dispensary/saveCategory'] = 'admin/dispensary/saveCategory';
$route['admin/dispensary/deleteCategory'] = 'admin/dispensary/deleteCategory';
$route['admin/dispensary/saveUnit'] = 'admin/dispensary/saveUnit';
$route['admin/dispensary/getUnit'] = 'admin/dispensary/getUnit';
$route['admin/dispensary/deleteUnit'] = 'admin/dispensary/deleteUnit';

// Maintenance endpoints
$route['admin/dispensary/clearCache'] = 'admin/dispensary/clearCache';
$route['admin/dispensary/optimizeDatabase'] = 'admin/dispensary/optimizeDatabase';
$route['admin/dispensary/cleanTempFiles'] = 'admin/dispensary/cleanTempFiles';
$route['admin/dispensary/rebuildIndexes'] = 'admin/dispensary/rebuildIndexes';
$route['admin/dispensary/createBackup'] = 'admin/dispensary/createBackup';
$route['admin/dispensary/backupHistory'] = 'admin/dispensary/backupHistory';
$route['admin/dispensary/testNotifications'] = 'admin/dispensary/testNotifications';
$route['admin/dispensary/exportSettings'] = 'admin/dispensary/exportSettings';

$route['admin/lab-reports/professional-report/(:num)'] = 'admin/lab_reports/generateProfessionalReport/$1';

// =============================================
// WELLNESS MODULE ROUTES
// Add these routes to your application/config/routes.php file
// =============================================

// Main wellness routes
$route['admin/wellness'] = 'admin/wellness/index';
$route['admin/wellness/index'] = 'admin/wellness/index';

// Visit management routes
$route['admin/wellness/create_visit'] = 'admin/wellness/create_visit';
$route['admin/wellness/visit_details/(:num)'] = 'admin/wellness/visit_details/$1';
$route['admin/wellness/update_visit'] = 'admin/wellness/update_visit';
$route['admin/wellness/delete_visit/(:num)'] = 'admin/wellness/delete_visit/$1';

// Service management routes
$route['admin/wellness/add_service'] = 'admin/wellness/add_service';
$route['admin/wellness/update_service'] = 'admin/wellness/update_service';
$route['admin/wellness/delete_service'] = 'admin/wellness/delete_service';
$route['admin/wellness/update_service_status'] = 'admin/wellness/update_service_status';

// Payment routes
$route['admin/wellness/process_payment'] = 'admin/wellness/process_payment';
$route['admin/wellness/payment_history/(:num)'] = 'admin/wellness/payment_history/$1';

// AJAX routes for dynamic data
$route['admin/wellness/get_services_by_type'] = 'admin/wellness/get_services_by_type';
$route['admin/wellness/get_service_price'] = 'admin/wellness/get_service_price';
$route['admin/wellness/get_dashboard_stats'] = 'admin/wellness/get_dashboard_stats';
$route['admin/wellness/get_recent_visits'] = 'admin/wellness/get_recent_visits';
$route['admin/wellness/get_visit_timeline'] = 'admin/wellness/get_visit_timeline';
$route['admin/wellness/get_visit_status'] = 'admin/wellness/get_visit_status';

// Reports routes
$route['admin/wellness/reports'] = 'admin/wellness/reports';
$route['admin/wellness/export_excel'] = 'admin/wellness/export_excel';
$route['admin/wellness/export_pdf'] = 'admin/wellness/export_pdf';
$route['admin/wellness/print_visit_summary/(:num)'] = 'admin/wellness/print_visit_summary/$1';
$route['admin/wellness/generate_receipt/(:num)'] = 'admin/wellness/generate_receipt/$1';

// Service catalog management routes
$route['admin/wellness/service_catalog'] = 'admin/wellness/service_catalog';
$route['admin/wellness/add_service_catalog'] = 'admin/wellness/add_service_catalog';
$route['admin/wellness/edit_service_catalog/(:num)'] = 'admin/wellness/edit_service_catalog/$1';
$route['admin/wellness/update_service_catalog'] = 'admin/wellness/update_service_catalog';
$route['admin/wellness/delete_service_catalog/(:num)'] = 'admin/wellness/delete_service_catalog/$1';

// Location management routes
$route['admin/wellness/locations'] = 'admin/wellness/locations';
$route['admin/wellness/add_location'] = 'admin/wellness/add_location';
$route['admin/wellness/edit_location/(:num)'] = 'admin/wellness/edit_location/$1';
$route['admin/wellness/update_location'] = 'admin/wellness/update_location';
$route['admin/wellness/delete_location/(:num)'] = 'admin/wellness/delete_location/$1';

// Search and filter routes
$route['admin/wellness/search_visits'] = 'admin/wellness/search_visits';
$route['admin/wellness/filter_by_location/(:any)'] = 'admin/wellness/filter_by_location/$1';
$route['admin/wellness/filter_by_date/(:any)/(:any)'] = 'admin/wellness/filter_by_date/$1/$2';

// API routes for mobile/external access (optional)
$route['api/wellness/create_visit'] = 'api/wellness/create_visit';
$route['api/wellness/get_visit/(:num)'] = 'api/wellness/get_visit/$1';
$route['api/wellness/update_visit/(:num)'] = 'api/wellness/update_visit/$1';

$route['admin/import'] = 'admin/import/index';
$route['admin/import/(:any)'] = 'admin/import/$1';

// =============================================
// HR MODULE ROUTES
// =============================================

// HR Dashboard and Main Routes
$route['admin/hr'] = 'admin/hr/index';
$route['admin/hr/index'] = 'admin/hr/index';
$route['admin/hr/dashboard'] = 'admin/hr/index';

// =============================================
// STAFF MANAGEMENT ROUTES
// =============================================

// Staff CRUD Operations
$route['admin/hr/staff'] = 'admin/hr/staff';
$route['admin/hr/staff/index'] = 'admin/hr/staff';
$route['admin/hr/addStaff'] = 'admin/hr/addStaff';
$route['admin/hr/editStaff/(:num)'] = 'admin/hr/editStaff/$1';
$route['admin/hr/viewStaff/(:num)'] = 'admin/hr/viewStaff/$1';
$route['admin/hr/deleteStaff/(:num)'] = 'admin/hr/deleteStaff/$1';

// Staff Data and AJAX Routes
$route['admin/hr/getStaffList'] = 'admin/hr/getStaffList';
$route['admin/hr/getStaffData/(:num)'] = 'admin/hr/getStaffData/$1';
$route['admin/hr/getStaffDetailsById/(:num)'] = 'admin/hr/getStaffDetailsById/$1';
$route['admin/hr/exportStaff'] = 'admin/hr/exportStaff';
$route['admin/hr/importStaff'] = 'admin/hr/importStaff';

// Staff Documents Management
$route['admin/hr/uploadDocument'] = 'admin/hr/uploadDocument';
$route['admin/hr/getStaffDocuments/(:num)'] = 'admin/hr/getStaffDocuments/$1';
$route['admin/hr/downloadDocument/(:num)'] = 'admin/hr/downloadDocument/$1';
$route['admin/hr/deleteDocument/(:num)'] = 'admin/hr/deleteDocument/$1';
$route['admin/hr/viewDocuments/(:num)'] = 'admin/hr/viewDocuments/$1';

// Staff Profile and Employment History
$route['admin/hr/getEmploymentHistory/(:num)'] = 'admin/hr/getEmploymentHistory/$1';
$route['admin/hr/addEmploymentHistory'] = 'admin/hr/addEmploymentHistory';
$route['admin/hr/updateEmploymentHistory/(:num)'] = 'admin/hr/updateEmploymentHistory/$1';

// =============================================
// ATTENDANCE MANAGEMENT ROUTES
// =============================================

// Attendance Main Routes
$route['admin/hr/attendance'] = 'admin/hr/attendance';
$route['admin/hr/attendance/index'] = 'admin/hr/attendance';

// Clock In/Out Operations
$route['admin/hr/clockIn'] = 'admin/hr/clockIn';
$route['admin/hr/clockOut'] = 'admin/hr/clockOut';
$route['admin/hr/getTodayAttendance/(:num)'] = 'admin/hr/getTodayAttendance/$1';

// Attendance Reports and Data
$route['admin/hr/getAttendanceList'] = 'admin/hr/getAttendanceList';
$route['admin/hr/getAttendanceReport'] = 'admin/hr/getAttendanceReport';
$route['admin/hr/getAttendanceByDate'] = 'admin/hr/getAttendanceByDate';
$route['admin/hr/exportAttendance'] = 'admin/hr/exportAttendance';

// Shift Management
$route['admin/hr/shifts'] = 'admin/hr/shifts';
$route['admin/hr/addShift'] = 'admin/hr/addShift';
$route['admin/hr/editShift/(:num)'] = 'admin/hr/editShift/$1';
$route['admin/hr/getShifts'] = 'admin/hr/getShifts';
$route['admin/hr/assignShift'] = 'admin/hr/assignShift';
$route['admin/hr/getStaffSchedule/(:num)'] = 'admin/hr/getStaffSchedule/$1';

// Overtime Management
$route['admin/hr/overtime'] = 'admin/hr/overtime';
$route['admin/hr/addOvertime'] = 'admin/hr/addOvertime';
$route['admin/hr/approveOvertime/(:num)'] = 'admin/hr/approveOvertime/$1';
$route['admin/hr/getOvertimeRecords'] = 'admin/hr/getOvertimeRecords';

// =============================================
// LEAVE MANAGEMENT ROUTES
// =============================================

// Leave Main Routes
$route['admin/hr/leave'] = 'admin/hr/leave';
$route['admin/hr/leave/index'] = 'admin/hr/leave';

// Leave Applications
$route['admin/hr/applyLeave'] = 'admin/hr/applyLeave';
$route['admin/hr/editLeave/(:num)'] = 'admin/hr/editLeave/$1';
$route['admin/hr/viewLeave/(:num)'] = 'admin/hr/viewLeave/$1';
$route['admin/hr/cancelLeave/(:num)'] = 'admin/hr/cancelLeave/$1';

// Leave Approval Workflow
$route['admin/hr/approveLeave/(:num)'] = 'admin/hr/approveLeave/$1';
$route['admin/hr/rejectLeave/(:num)'] = 'admin/hr/rejectLeave/$1';
$route['admin/hr/getLeaveApprovalLog/(:num)'] = 'admin/hr/getLeaveApprovalLog/$1';

// Leave Data and Reports
$route['admin/hr/getLeaveList'] = 'admin/hr/getLeaveList';
$route['admin/hr/getLeaveBalance/(:num)'] = 'admin/hr/getLeaveBalance/$1';
$route['admin/hr/getLeaveCalendar'] = 'admin/hr/getLeaveCalendar';
$route['admin/hr/getLeaveReport'] = 'admin/hr/getLeaveReport';
$route['admin/hr/exportLeaveReport'] = 'admin/hr/exportLeaveReport';

// Leave Types and Settings
$route['admin/hr/leaveTypes'] = 'admin/hr/leaveTypes';
$route['admin/hr/addLeaveType'] = 'admin/hr/addLeaveType';
$route['admin/hr/editLeaveType/(:num)'] = 'admin/hr/editLeaveType/$1';
$route['admin/hr/getLeaveTypes'] = 'admin/hr/getLeaveTypes';

// Leave Balance Management
$route['admin/hr/adjustLeaveBalance'] = 'admin/hr/adjustLeaveBalance';
$route['admin/hr/initializeLeaveBalance/(:num)'] = 'admin/hr/initializeLeaveBalance/$1';
$route['admin/hr/processCarryover/(:num)'] = 'admin/hr/processCarryover/$1';

// =============================================
// PAYROLL MANAGEMENT ROUTES
// =============================================

// Payroll Main Routes
$route['admin/hr/payroll'] = 'admin/hr/payroll';
$route['admin/hr/payroll/index'] = 'admin/hr/payroll';

// Payroll Generation and Processing
$route['admin/hr/generatePayroll'] = 'admin/hr/generatePayroll';
$route['admin/hr/getPayrollList'] = 'admin/hr/getPayrollList';
$route['admin/hr/getPayrollById/(:num)'] = 'admin/hr/getPayrollById/$1';
$route['admin/hr/approvePayroll/(:num)'] = 'admin/hr/approvePayroll/$1';
$route['admin/hr/deletePayroll/(:num)'] = 'admin/hr/deletePayroll/$1';

// On-Demand Payroll Processing
$route['admin/hr/processPayrollOnDemand'] = 'admin/hr/processPayrollOnDemand';
$route['admin/hr/quickPayrollRun'] = 'admin/hr/quickPayrollRun';
$route['admin/hr/previewPayroll'] = 'admin/hr/previewPayroll';
$route['admin/hr/getPayrollStatus'] = 'admin/hr/getPayrollStatus';
$route['admin/hr/getPayrollHistory'] = 'admin/hr/getPayrollHistory';

// Payroll Reports and Analytics
$route['admin/hr/getPayrollSummary'] = 'admin/hr/getPayrollSummary';
$route['admin/hr/getDepartmentPayrollSummary'] = 'admin/hr/getDepartmentPayrollSummary';
$route['admin/hr/getStatutoryRemittanceReport'] = 'admin/hr/getStatutoryRemittanceReport';
$route['admin/hr/exportPayrollReport'] = 'admin/hr/exportPayrollReport';

// Payroll Adjustments
$route['admin/hr/addPayrollAdjustment'] = 'admin/hr/addPayrollAdjustment';
$route['admin/hr/getPayrollAdjustments'] = 'admin/hr/getPayrollAdjustments';
$route['admin/hr/approveAdjustment/(:num)'] = 'admin/hr/approveAdjustment/$1';

// Salary Structure Management
$route['admin/hr/salaryStructure'] = 'admin/hr/salaryStructure';
$route['admin/hr/getSalaryComponents'] = 'admin/hr/getSalaryComponents';
$route['admin/hr/addSalaryComponent'] = 'admin/hr/addSalaryComponent';
$route['admin/hr/editSalaryComponent/(:num)'] = 'admin/hr/editSalaryComponent/$1';
$route['admin/hr/getStaffSalaryStructure/(:num)'] = 'admin/hr/getStaffSalaryStructure/$1';
$route['admin/hr/updateStaffSalaryStructure/(:num)'] = 'admin/hr/updateStaffSalaryStructure/$1';

// Instant Payslip Generation
$route['admin/hr/instantPayslipGeneration'] = 'admin/hr/instantPayslipGeneration';
$route['admin/hr/bulkEmailPayslips'] = 'admin/hr/bulkEmailPayslips';

// =============================================
// PAYSLIP ROUTES
// =============================================

// Payslip Generation and Management
$route['admin/payslip'] = 'admin/payslip/index';
$route['admin/payslip/generate/(:num)'] = 'admin/payslip/generate/$1';
$route['admin/payslip/email/(:num)'] = 'admin/payslip/email/$1';
$route['admin/payslip/view/(:num)'] = 'admin/payslip/view/$1';
$route['admin/payslip/download/(:num)'] = 'admin/payslip/download/$1';

// Bulk Payslip Operations
$route['admin/payslip/bulkGenerate'] = 'admin/payslip/bulkGenerate';
$route['admin/payslip/bulkEmail'] = 'admin/payslip/bulkEmail';
$route['admin/payslip/bulkDownload'] = 'admin/payslip/bulkDownload';

// Payslip Templates and Settings
$route['admin/payslip/template'] = 'admin/payslip/template';
$route['admin/payslip/settings'] = 'admin/payslip/settings';

// =============================================
// P9 TAX CERTIFICATE ROUTES
// =============================================

// P9 Main Routes
$route['admin/p9'] = 'admin/p9/index';
$route['admin/p9/index'] = 'admin/p9/index';
$route['admin/p9/dashboard'] = 'admin/p9/index';

// P9 Generation
$route['admin/p9/generate/(:num)/(:num)'] = 'admin/p9/generate/$1/$2'; // staff_id/year
$route['admin/p9/generate/(:num)'] = 'admin/p9/generate/$1'; // staff_id (current year)
$route['admin/p9/bulkGenerate'] = 'admin/p9/bulkGenerate';
$route['admin/p9/previewGeneration'] = 'admin/p9/previewGeneration';

// P9 Data and Management
$route['admin/p9/getP9List'] = 'admin/p9/getP9List';
$route['admin/p9/getDetails/(:num)/(:num)'] = 'admin/p9/getDetails/$1/$2'; // staff_id/year
$route['admin/p9/validateData'] = 'admin/p9/validateData';
$route['admin/p9/getP9Status/(:num)/(:num)'] = 'admin/p9/getP9Status/$1/$2';

// P9 Email and Delivery
$route['admin/p9/email/(:num)/(:num)'] = 'admin/p9/email/$1/$2'; // staff_id/year
$route['admin/p9/bulkEmail'] = 'admin/p9/bulkEmail';
$route['admin/p9/download/(:num)/(:num)'] = 'admin/p9/download/$1/$2';

// P9 Analytics and Reports
$route['admin/p9/analytics'] = 'admin/p9/analytics';
$route['admin/p9/getAnalytics'] = 'admin/p9/getAnalytics';
$route['admin/p9/exportForKRA'] = 'admin/p9/exportForKRA';
$route['admin/p9/getKRAExport'] = 'admin/p9/getKRAExport';

// P9 Setup and Configuration
$route['admin/p9/setup'] = 'admin/p9/setup';
$route['admin/p9/settings'] = 'admin/p9/settings';

// =============================================
// TRAINING AND DEVELOPMENT ROUTES
// =============================================

// Training Main Routes
$route['admin/hr/training'] = 'admin/hr/training';
$route['admin/hr/training/index'] = 'admin/hr/training';

// Training Courses Management
$route['admin/hr/trainingCourses'] = 'admin/hr/trainingCourses';
$route['admin/hr/addTrainingCourse'] = 'admin/hr/addTrainingCourse';
$route['admin/hr/editTrainingCourse/(:num)'] = 'admin/hr/editTrainingCourse/$1';
$route['admin/hr/viewTrainingCourse/(:num)'] = 'admin/hr/viewTrainingCourse/$1';
$route['admin/hr/getTrainingCourses'] = 'admin/hr/getTrainingCourses';

// Training Enrollments
$route['admin/hr/enrollStaff'] = 'admin/hr/enrollStaff';
$route['admin/hr/bulkEnrollStaff'] = 'admin/hr/bulkEnrollStaff';
$route['admin/hr/getTrainingEnrollments'] = 'admin/hr/getTrainingEnrollments';
$route['admin/hr/markTrainingComplete/(:num)'] = 'admin/hr/markTrainingComplete/$1';

// Training Sessions
$route['admin/hr/trainingSessions'] = 'admin/hr/trainingSessions';
$route['admin/hr/scheduleTrainingSession'] = 'admin/hr/scheduleTrainingSession';
$route['admin/hr/getTrainingSessions'] = 'admin/hr/getTrainingSessions';
$route['admin/hr/markSessionAttendance'] = 'admin/hr/markSessionAttendance';
$route['admin/hr/getSessionAttendance/(:num)'] = 'admin/hr/getSessionAttendance/$1';

// Training Reports and Analytics
$route['admin/hr/getTrainingReport'] = 'admin/hr/getTrainingReport';
$route['admin/hr/getTrainingStatistics'] = 'admin/hr/getTrainingStatistics';
$route['admin/hr/getStaffTrainingHistory/(:num)'] = 'admin/hr/getStaffTrainingHistory/$1';
$route['admin/hr/getTrainingCompletionRate'] = 'admin/hr/getTrainingCompletionRate';

// Skill Matrix Management
$route['admin/hr/skillMatrix'] = 'admin/hr/skillMatrix';
$route['admin/hr/getStaffSkillMatrix/(:num)'] = 'admin/hr/getStaffSkillMatrix/$1';
$route['admin/hr/updateStaffSkillMatrix'] = 'admin/hr/updateStaffSkillMatrix';
$route['admin/hr/getExpiringCertifications'] = 'admin/hr/getExpiringCertifications';

// Training Categories
$route['admin/hr/trainingCategories'] = 'admin/hr/trainingCategories';
$route['admin/hr/addTrainingCategory'] = 'admin/hr/addTrainingCategory';
$route['admin/hr/editTrainingCategory/(:num)'] = 'admin/hr/editTrainingCategory/$1';
$route['admin/hr/getTrainingCategories'] = 'admin/hr/getTrainingCategories';

// =============================================
// PERFORMANCE MANAGEMENT ROUTES
// =============================================

// Performance Reviews
$route['admin/hr/performance'] = 'admin/hr/performance';
$route['admin/hr/performanceReviews'] = 'admin/hr/performanceReviews';
$route['admin/hr/addPerformanceReview'] = 'admin/hr/addPerformanceReview';
$route['admin/hr/editPerformanceReview/(:num)'] = 'admin/hr/editPerformanceReview/$1';
$route['admin/hr/viewPerformanceReview/(:num)'] = 'admin/hr/viewPerformanceReview/$1';
$route['admin/hr/getPerformanceReviews'] = 'admin/hr/getPerformanceReviews';

// Probation Management
$route['admin/hr/probation'] = 'admin/hr/probation';
$route['admin/hr/getProbationaryStaff'] = 'admin/hr/getProbationaryStaff';
$route['admin/hr/getExpiringProbations'] = 'admin/hr/getExpiringProbations';
$route['admin/hr/completeProbation/(:num)'] = 'admin/hr/completeProbation/$1';

// =============================================
// HR REPORTS AND ANALYTICS ROUTES
// =============================================

// HR Reports Main
$route['admin/hr/reports'] = 'admin/hr/reports';
$route['admin/hr/reports/index'] = 'admin/hr/reports';

// Dashboard Analytics
$route['admin/hr/getDashboardStats'] = 'admin/hr/getDashboardStats';
$route['admin/hr/getDepartmentHeadcount'] = 'admin/hr/getDepartmentHeadcount';
$route['admin/hr/getAttendanceTrend'] = 'admin/hr/getAttendanceTrend';
$route['admin/hr/getStaffSummary'] = 'admin/hr/getStaffSummary';
$route['admin/hr/getLeaveSummary'] = 'admin/hr/getLeaveSummary';
$route['admin/hr/getTrainingSummary'] = 'admin/hr/getTrainingSummary';

// Comprehensive Reports
$route['admin/hr/getHeadcountReport'] = 'admin/hr/getHeadcountReport';
$route['admin/hr/getAttritionReport'] = 'admin/hr/getAttritionReport';
$route['admin/hr/getComplianceReport'] = 'admin/hr/getComplianceReport';
$route['admin/hr/exportHRReport'] = 'admin/hr/exportHRReport';

// =============================================
// HR SETTINGS AND CONFIGURATION ROUTES
// =============================================

// HR Settings Main
$route['admin/hr/settings'] = 'admin/hr/settings';
$route['admin/hr/settings/index'] = 'admin/hr/settings';

// Department Management
$route['admin/hr/departments'] = 'admin/hr/departments';
$route['admin/hr/addDepartment'] = 'admin/hr/addDepartment';
$route['admin/hr/editDepartment/(:num)'] = 'admin/hr/editDepartment/$1';
$route['admin/hr/deleteDepartment/(:num)'] = 'admin/hr/deleteDepartment/$1';
$route['admin/hr/getDepartments'] = 'admin/hr/getDepartments';

// Role Management
$route['admin/hr/roles'] = 'admin/hr/roles';
$route['admin/hr/addRole'] = 'admin/hr/addRole';
$route['admin/hr/editRole/(:num)'] = 'admin/hr/editRole/$1';
$route['admin/hr/deleteRole/(:num)'] = 'admin/hr/deleteRole/$1';
$route['admin/hr/getRoles'] = 'admin/hr/getRoles';

// Holiday Management
$route['admin/hr/holidays'] = 'admin/hr/holidays';
$route['admin/hr/addHoliday'] = 'admin/hr/addHoliday';
$route['admin/hr/editHoliday/(:num)'] = 'admin/hr/editHoliday/$1';
$route['admin/hr/deleteHoliday/(:num)'] = 'admin/hr/deleteHoliday/$1';
$route['admin/hr/getHolidays'] = 'admin/hr/getHolidays';

// System Configuration
$route['admin/hr/updateSettings'] = 'admin/hr/updateSettings';
$route['admin/hr/getSettings'] = 'admin/hr/getSettings';
$route['admin/hr/resetSettings'] = 'admin/hr/resetSettings';

// =============================================
// HR UTILITIES AND HELPER ROUTES
// =============================================

// Activity Logs
$route['admin/hr/activityLog'] = 'admin/hr/activityLog';
$route['admin/hr/getActivityLog'] = 'admin/hr/getActivityLog';
$route['admin/hr/exportActivityLog'] = 'admin/hr/exportActivityLog';

// Data Import/Export
$route['admin/hr/import'] = 'admin/hr/import';
$route['admin/hr/export'] = 'admin/hr/export';
$route['admin/hr/importData'] = 'admin/hr/importData';
$route['admin/hr/exportData'] = 'admin/hr/exportData';
$route['admin/hr/downloadTemplate/(:any)'] = 'admin/hr/downloadTemplate/$1';

// Backup and Restore
$route['admin/hr/backup'] = 'admin/hr/backup';
$route['admin/hr/restore'] = 'admin/hr/restore';
$route['admin/hr/createBackup'] = 'admin/hr/createBackup';
$route['admin/hr/restoreBackup'] = 'admin/hr/restoreBackup';

// System Health and Diagnostics
$route['admin/hr/systemHealth'] = 'admin/hr/systemHealth';
$route['admin/hr/runDiagnostics'] = 'admin/hr/runDiagnostics';
$route['admin/hr/testConnections'] = 'admin/hr/testConnections';

// Setup and Installation
$route['admin/hr/setup'] = 'admin/hr/setup';
$route['admin/hr/install'] = 'admin/hr/install';
$route['admin/hr/createTables'] = 'admin/hr/createTables';
$route['admin/hr/seedData'] = 'admin/hr/seedData';

// =============================================
// API ROUTES (for mobile app or external integrations)
// =============================================

// Staff API Routes
$route['api/hr/staff'] = 'api/hr/staff';
$route['api/hr/staff/(:num)'] = 'api/hr/staff/$1';
$route['api/hr/staff/search'] = 'api/hr/searchStaff';

// Attendance API Routes
$route['api/hr/attendance/clockin'] = 'api/hr/clockIn';
$route['api/hr/attendance/clockout'] = 'api/hr/clockOut';
$route['api/hr/attendance/status/(:num)'] = 'api/hr/getAttendanceStatus/$1';

// Leave API Routes
$route['api/hr/leave/apply'] = 'api/hr/applyLeave';
$route['api/hr/leave/balance/(:num)'] = 'api/hr/getLeaveBalance/$1';
$route['api/hr/leave/history/(:num)'] = 'api/hr/getLeaveHistory/$1';

// Payslip API Routes
$route['api/hr/payslip/(:num)/(:num)/(:num)'] = 'api/hr/getPayslip/$1/$2/$3'; // staff_id/month/year
$route['api/hr/payslip/email'] = 'api/hr/emailPayslip';

// P9 API Routes
$route['api/hr/p9/(:num)/(:num)'] = 'api/hr/getP9/$1/$2'; // staff_id/year
$route['api/hr/p9/email'] = 'api/hr/emailP9';

// =============================================
// ADMIN PANEL INTEGRATION ROUTES
// =============================================

// Menu Integration
$route['admin/hr/getMenuItems'] = 'admin/hr/getMenuItems';
$route['admin/hr/getQuickActions'] = 'admin/hr/getQuickActions';
$route['admin/hr/getNotifications'] = 'admin/hr/getNotifications';

// Dashboard Integration
$route['admin/hr/getDashboardWidgets'] = 'admin/hr/getDashboardWidgets';
$route['admin/hr/getKPIs'] = 'admin/hr/getKPIs';
$route['admin/hr/getAlerts'] = 'admin/hr/getAlerts';

// =============================================
// ROUTE ALIASES FOR CONVENIENCE
// =============================================

// Short aliases for frequently used routes
$route['hr'] = 'admin/hr';
$route['hr/staff'] = 'admin/hr/staff';
$route['hr/payroll'] = 'admin/hr/payroll';
$route['hr/attendance'] = 'admin/hr/attendance';
$route['hr/leave'] = 'admin/hr/leave';
$route['hr/training'] = 'admin/hr/training';
$route['hr/reports'] = 'admin/hr/reports';
$route['hr/settings'] = 'admin/hr/settings';

// P9 and Payslip shortcuts
$route['p9'] = 'admin/p9';
$route['payslip'] = 'admin/payslip';

// Mobile-friendly routes
$route['mobile/hr/clockin'] = 'api/hr/clockIn';
$route['mobile/hr/clockout'] = 'api/hr/clockOut';
$route['mobile/hr/leave'] = 'api/hr/leave';
$route['mobile/hr/payslip'] = 'api/hr/payslip';

// Main Dashboard
$route['admin/marketing'] = 'admin/marketing/index';
$route['admin/marketing/dashboard'] = 'admin/marketing/index';

// Patient Acquisition
$route['admin/marketing/acquisition'] = 'admin/marketing/acquisition';
$route['admin/marketing/acquisition/funnel'] = 'admin/marketing/get_acquisition_funnel';
$route['admin/marketing/acquisition/sources'] = 'admin/marketing/get_acquisition_sources';

// Campaign Management
$route['admin/marketing/campaigns'] = 'admin/marketing/campaigns';
$route['admin/marketing/campaigns/create'] = 'admin/marketing/create_campaign';
$route['admin/marketing/campaigns/edit/(:num)'] = 'admin/marketing/edit_campaign/$1';
$route['admin/marketing/campaigns/delete/(:num)'] = 'admin/marketing/delete_campaign/$1';
$route['admin/marketing/campaigns/view/(:num)'] = 'admin/marketing/view_campaign/$1';
$route['admin/marketing/campaigns/status'] = 'admin/marketing/update_campaign_status';
$route['admin/marketing/campaigns/metrics/(:num)'] = 'admin/marketing/get_campaign_metrics/$1';

// Revenue Analytics
$route['admin/marketing/revenue'] = 'admin/marketing/revenue_analytics';
$route['admin/marketing/revenue/breakdown'] = 'admin/marketing/get_revenue_breakdown';
$route['admin/marketing/revenue/department'] = 'admin/marketing/get_department_revenue';
$route['admin/marketing/revenue/forecast'] = 'admin/marketing/get_revenue_forecast';

// Patient Segmentation
$route['admin/marketing/segmentation'] = 'admin/marketing/segmentation';
$route['admin/marketing/segments/create'] = 'admin/marketing/create_segment';
$route['admin/marketing/segments/view/(:num)'] = 'admin/marketing/view_segment/$1';
$route['admin/marketing/segments/export/(:num)'] = 'admin/marketing/export_segment/$1';

// Reports
$route['admin/marketing/reports'] = 'admin/marketing/reports';
$route['admin/marketing/reports/generate'] = 'admin/marketing/generate_report';
$route['admin/marketing/reports/download/(:any)'] = 'admin/marketing/download_report/$1';
$route['admin/marketing/reports/saved'] = 'admin/marketing/saved_reports';
$route['admin/marketing/reports/load/(:num)'] = 'admin/marketing/load_saved_report/$1';
$route['admin/marketing/reports/schedule'] = 'admin/marketing/schedule_report';
$route['admin/marketing/reports/schedule/delete/(:num)'] = 'admin/marketing/delete_schedule/$1';

// Competitor Analysis
$route['admin/marketing/competitors'] = 'admin/marketing/competitor_analysis';
$route['admin/marketing/competitors/add'] = 'admin/marketing/add_competitor';
$route['admin/marketing/competitors/edit/(:num)'] = 'admin/marketing/edit_competitor/$1';
$route['admin/marketing/competitors/swot'] = 'admin/marketing/swot_analysis';

// Patient Feedback
$route['admin/marketing/feedback'] = 'admin/marketing/feedback';
$route['admin/marketing/feedback/respond/(:num)'] = 'admin/marketing/respond_feedback/$1';
$route['admin/marketing/feedback/sentiment'] = 'admin/marketing/get_sentiment_analysis';
$route['admin/marketing/feedback/nps'] = 'admin/marketing/get_nps_score';

// Email Marketing
$route['admin/marketing/email'] = 'admin/marketing/email_marketing';
$route['admin/marketing/email/campaigns'] = 'admin/marketing/email_campaigns';
$route['admin/marketing/email/campaigns/create'] = 'admin/marketing/create_email_campaign';
$route['admin/marketing/email/lists'] = 'admin/marketing/email_lists';
$route['admin/marketing/email/templates'] = 'admin/marketing/email_templates';
$route['admin/marketing/email/send'] = 'admin/marketing/send_email';

// Social Media
$route['admin/marketing/social'] = 'admin/marketing/social_media';
$route['admin/marketing/social/metrics'] = 'admin/marketing/get_social_metrics';
$route['admin/marketing/social/engagement'] = 'admin/marketing/get_engagement_rates';

// Marketing Calendar
$route['admin/marketing/calendar'] = 'admin/marketing/calendar';
$route['admin/marketing/calendar/events'] = 'admin/marketing/get_events';
$route['admin/marketing/calendar/add'] = 'admin/marketing/add_event';
$route['admin/marketing/calendar/edit/(:num)'] = 'admin/marketing/edit_event/$1';

// Settings
$route['admin/marketing/settings'] = 'admin/marketing/settings';
$route['admin/marketing/settings/update'] = 'admin/marketing/update_settings';
$route['admin/marketing/settings/attribution'] = 'admin/marketing/attribution_settings';

$route['admin/front_office'] = 'front_office/dashboard';
$route['admin/front_office/dashboard'] = 'front_office/dashboard';

$route['admin/laboratory/getQueueStatus'] = 'laboratory/getQueueStatus';

$route['admin/triage/getPatientTriageHistory'] = 'admin/triage/getPatientTriageHistory';
$route['admin/triage/debugTriageTable'] = 'admin/triage/debugTriageTable';

// Insurance module routes
$route['admin/insurance'] = 'admin/insurance/index';
$route['admin/insurance/companies'] = 'admin/insurance/companies';
$route['admin/insurance/pricing'] = 'admin/insurance/pricing';
$route['admin/insurance/import'] = 'admin/insurance/import_pricing';
$route['admin/insurance/import/pricing'] = 'admin/insurance/import_pricing';
$route['admin/insurance/dashboard'] = 'admin/insurance/dashboard';
$route['admin/insurance/comparison'] = 'admin/insurance/pricing_comparison';
$route['admin/insurance/history'] = 'admin/insurance/import_history';

// Control Center Main Routes
$route['admin/control-center'] = 'admin/control_center/index';
$route['admin/control-center/dashboard'] = 'admin/control_center/index';

// Real-time Data Endpoints
$route['admin/control-center/api/dashboard-data'] = 'admin/control_center/get_dashboard_data';
$route['admin/control-center/api/system-health'] = 'admin/control_center/get_system_health';
$route['admin/control-center/api/department-stats/(:any)'] = 'admin/control_center/get_department_stats/$1';
$route['admin/control-center/api/queue-status'] = 'admin/control_center/get_queue_status';

// System Administration
$route['admin/control-center/maintenance'] = 'admin/control_center/maintenance';
$route['admin/control-center/reports'] = 'admin/control_center/reports';
$route['admin/control-center/system-logs'] = 'admin/control_center/system_logs';

// System Operations
$route['admin/control-center/clear-cache'] = 'admin/control_center/clear_cache';
$route['admin/control-center/optimize-database'] = 'admin/control_center/optimize_database';
$route['admin/control-center/backup-system'] = 'admin/control_center/backup_system';

// Ticket Management
$route['admin/control-center/tickets'] = 'admin/control_center/tickets';
$route['admin/control-center/tickets/data'] = 'admin/control_center/get_tickets_data';
$route['admin/control-center/tickets/create'] = 'admin/control_center/create_ticket';
$route['admin/control-center/tickets/update/(:num)'] = 'admin/control_center/update_ticket/$1';
$route['admin/control-center/tickets/view/(:num)'] = 'admin/control_center/view_ticket/$1';

// Performance Monitoring
$route['admin/control-center/performance'] = 'admin/control_center/performance_monitor';
$route['admin/control-center/performance/real-time'] = 'admin/control_center/real_time_performance';

// Settings and Configuration
$route['admin/control-center/settings'] = 'admin/control_center/settings';
$route['admin/control-center/settings/update'] = 'admin/control_center/update_settings';
