<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Import System Configuration
 */

// File upload settings
$config['import_max_file_size'] = 5120; // 5MB in KB
$config['import_allowed_types'] = 'xls|xlsx|csv';
$config['import_upload_path'] = './uploads/imports/';

// Import modules
$config['import_modules'] = array(
    'nursing_consumables' => array(
        'name' => 'Nursing Consumables',
        'description' => 'Import nursing consumables and medical supplies',
        'target_table' => 'consumables',
        'category_id' => 1,
        'required_columns' => array('item_name', 'closing_stock'),
        'optional_columns' => array('opening_stock', 'added', 'transfer_in', 'transfer_out', 'sales', 'adjusted', 'value'),
        'default_unit' => 'pieces',
        'code_prefix' => 'NUR'
    ),
    'pharmacy_stock' => array(
        'name' => 'Pharmacy Stock',
        'description' => 'Import pharmacy stock and medications',
        'target_table' => 'pharmacy_stock_items',
        'category_id' => 2,
        'required_columns' => array('item_name', 'closing_stock'),
        'optional_columns' => array('opening_stock', 'added', 'transfer_in', 'transfer_out', 'assembly', 'sales', 'adjusted', 'value'),
        'default_unit' => 'tablets',
        'code_prefix' => 'PHR'
    ),
    'lab_consumables' => array(
        'name' => 'Laboratory Consumables',
        'description' => 'Import laboratory supplies and consumables',
        'target_table' => 'consumables',
        'category_id' => 4,
        'required_columns' => array('item_name', 'closing_stock'),
        'optional_columns' => array('opening_stock', 'added', 'transfer_in', 'transfer_out', 'sales', 'adjusted', 'value'),
        'default_unit' => 'pieces',
        'code_prefix' => 'LAB'
    )
);

// Validation rules
$config['import_validation'] = array(
    'required_fields' => array('item_name', 'closing_stock'),
    'numeric_fields' => array('opening_stock', 'added', 'transfer_in', 'transfer_out', 'assembly', 'sales', 'adjusted', 'closing_stock', 'value'),
    'max_item_name_length' => 255,
    'min_stock_value' => 0,
    'max_records_per_import' => 5000
);